/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.bitbucket.repository.CreateTagRequest;
import com.atlassian.bitbucket.repository.RefOrder;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryTagsRequest;
import com.atlassian.bitbucket.rest.repository.RestMinimalRef;
import com.atlassian.bitbucket.rest.repository.RestTag;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.repository.AbstractRepositoryRefResource;
import com.atlassian.stash.internal.rest.repository.RestCreateTagRequest;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="projects/{projectKey}/repos/{repositorySlug}/tags")
@Singleton
@AnonymousAllowed
public class TagResource
extends AbstractRepositoryRefResource {
    public TagResource(RefService refService) {
        super(refService);
    }

    @GET
    public Response getTags(@Context Repository repository, final @Context PageRequest pageRequest, final @QueryParam(value="filterText") String filterText, final @QueryParam(value="orderBy") String orderBy) {
        return this.process(repository, new AbstractRepositoryRefResource.RepositoryCallback(){

            @Override
            public RestPage<RestMinimalRef> doWithRepository(Repository repository, RefService refService) {
                Page tags = refService.getTags(((RepositoryTagsRequest.Builder)((RepositoryTagsRequest.Builder)new RepositoryTagsRequest.Builder(repository).filterText(filterText)).order(RefOrder.fromValueOrNull((String)orderBy))).build(), pageRequest);
                return new RestPage<RestMinimalRef>(tags, RestMinimalRef.REST_TRANSFORM);
            }
        });
    }

    @POST
    public Response createTag(@Context Repository repository, RestCreateTagRequest restRequest) {
        return this.process(repository, (repo, refService) -> new RestTag(refService.createTag(((CreateTagRequest.Builder)new CreateTagRequest.Builder(repo, restRequest.getName(), restRequest.getStartPoint()).message(restRequest.getMessage())).build())));
    }
}

