/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestDirection;
import com.atlassian.bitbucket.pull.PullRequestParticipantSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Locale;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/participants")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class PullRequestParticipantSearchResource
extends AbstractPullRequestResource {
    public PullRequestParticipantSearchResource(I18nService i18nService, PullRequestService pullRequestService) {
        super(i18nService, pullRequestService);
    }

    @GET
    public Response search(@Context Repository repository, @QueryParam(value="direction") @DefaultValue(value="incoming") String direction, @QueryParam(value="filter") String filter, @QueryParam(value="role") String role, @Context PageRequest pageRequest) {
        PullRequestParticipantSearchRequest.Builder builder = new PullRequestParticipantSearchRequest.Builder();
        if (PullRequestDirection.OUTGOING.equals((Object)this.toDirection(direction))) {
            builder.fromRepository(repository);
        } else {
            builder.toRepository(repository);
        }
        builder.filter(filter);
        if (StringUtils.isNotBlank((CharSequence)role)) {
            builder.role(this.toRole(role));
        }
        Page page = this.pullRequestService.searchUsers(builder.build(), pageRequest);
        return ResponseFactory.ok(new RestPage<RestApplicationUser>(page, RestApplicationUser::new)).build();
    }

    private PullRequestRole toRole(String role) {
        try {
            return PullRequestRole.valueOf((String)role.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.participants.role.invalid", new Object[]{role, this.toLowercaseNames((Enum[])PullRequestRole.values())}));
        }
    }
}

