/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.comment.AddDiffCommentRequest;
import com.atlassian.bitbucket.comment.AddFileCommentRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.comment.RestComment;
import com.atlassian.bitbucket.rest.comment.RestDiffCommentAnchor;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.sun.jersey.spi.resource.Singleton;
import java.net.URI;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class PullRequestCommentResource
extends AbstractPullRequestResource {
    public PullRequestCommentResource(I18nService i18nService, PullRequestService pullRequestService) {
        super(i18nService, pullRequestService);
    }

    @POST
    public Response createComment(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @Context UriInfo uriInfo, RestComment comment) {
        RestDiffCommentAnchor anchor;
        String commentText = comment.getText();
        if (StringUtils.isBlank((CharSequence)commentText)) {
            String message = this.i18nService.getMessage("bitbucket.rest.comment.addrequirestext", new Object[0]);
            throw new BadRequestException(message);
        }
        Comment created = comment.isReply() ? this.pullRequestService.addReply(repository.getId(), pullRequestId, comment.getParent().getId(), commentText) : (comment.isAnchored() ? ((anchor = comment.getAnchor()).isLineComment() ? this.pullRequestService.addDiffComment(repository.getId(), pullRequestId, ((AddDiffCommentRequest.Builder)anchor.toLine(this.i18nService).text(commentText)).build()) : this.pullRequestService.addFileComment(repository.getId(), pullRequestId, ((AddFileCommentRequest.Builder)anchor.toFile(this.i18nService).text(commentText)).build())) : this.pullRequestService.addComment(repository.getId(), pullRequestId, commentText));
        URI uri = uriInfo.getRequestUriBuilder().path(String.valueOf(created.getId())).build(new Object[0]);
        return ResponseFactory.created(uri).entity((Object)new RestComment(created)).build();
    }

    @DELETE
    @Path(value="{commentId}")
    public Response deleteComment(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @PathParam(value="commentId") long commentId, @QueryParam(value="version") @DefaultValue(value="-1") int version) {
        this.pullRequestService.deleteComment(repository.getId(), pullRequestId, commentId, version);
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="{commentId}")
    public Response getComment(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @PathParam(value="commentId") long commentId) {
        Comment comment = this.pullRequestService.getComment(repository.getId(), pullRequestId, commentId);
        return ResponseFactory.ok(new RestComment(comment)).build();
    }

    @GET
    public Response getComments(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @QueryParam(value="path") String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.comments.findrequirespath", new Object[0]));
        }
        List comments = Chainable.chain((Iterable)this.pullRequestService.findCommentAnchors(repository.getId(), pullRequestId, path)).transform(RestComment.FROM_ANCHOR::apply).toList();
        Page page = PageUtils.createPage((Iterable)comments, (boolean)true, (PageRequest)PageUtils.newRequest((int)0, (int)Math.max(25, comments.size())));
        return ResponseFactory.ok(new RestPage(page)).build();
    }

    @PUT
    @Path(value="{commentId}")
    public Response updateComment(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @PathParam(value="commentId") long commentId, RestComment comment) {
        if (StringUtils.isBlank((CharSequence)comment.getText())) {
            String message = this.i18nService.getMessage("bitbucket.rest.comment.updaterequirestext", new Object[0]);
            throw new BadRequestException(message);
        }
        Comment updated = this.pullRequestService.updateComment(repository.getId(), pullRequestId, commentId, comment.getVersion(), comment.getText());
        return ResponseFactory.ok(new RestComment(updated)).build();
    }
}

