/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitContext;
import com.atlassian.bitbucket.commit.CommitSummary;
import com.atlassian.bitbucket.rest.commit.RestCommit;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class JsonCommitCallback
extends AbstractCommitCallback {
    private final Set<String> authors = Sets.newHashSet();
    private final Function<Commit, RestCommit> commitTransformer;
    private final PageRequest pageRequest;
    private final boolean withCounts;
    private final StatefulJsonWriter writer;
    private int commitCount;
    private int pageSize;

    public JsonCommitCallback(StatefulJsonWriter writer, Function<Commit, RestCommit> commitTransformer, boolean withCounts, PageRequest pageRequest) {
        this.commitTransformer = commitTransformer;
        this.pageRequest = pageRequest;
        this.withCounts = withCounts && pageRequest.getStart() == 0;
        this.writer = writer;
    }

    public boolean onCommit(@Nonnull Commit commit) throws IOException {
        boolean requestNext;
        ++this.commitCount;
        if (this.commitCount >= this.pageRequest.getStart() + 1 && this.commitCount <= this.pageRequest.getStart() + this.pageRequest.getLimit()) {
            this.writer.value(this.commitTransformer.apply(commit));
            ++this.pageSize;
        }
        boolean bl = requestNext = this.withCounts || this.commitCount <= this.pageRequest.getStart() + this.pageRequest.getLimit() + 1;
        if (this.withCounts) {
            this.authors.add(commit.getAuthor().getName());
        }
        return requestNext;
    }

    public void onEnd(@Nonnull CommitSummary summary) throws IOException {
        boolean lastPage = this.commitCount <= this.pageRequest.getStart() + this.pageRequest.getLimit();
        this.writer.endArray().name("size").value(this.pageSize).name("isLastPage").value(lastPage).name("start").value(this.pageRequest.getStart()).name("limit").value(this.pageRequest.getLimit()).name("nextPageStart");
        if (lastPage) {
            this.writer.nullValue();
        } else {
            this.writer.value(this.pageRequest.getStart() + this.pageRequest.getLimit());
        }
        if (this.withCounts) {
            this.writer.name("authorCount").value(this.authors.size()).name("totalCount").value(this.commitCount);
        }
        this.writer.endObject();
    }

    public void onStart(@Nonnull CommitContext context) throws IOException {
        this.writer.beginObject().name("values").beginArray();
    }
}

