/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.log;

import com.atlassian.bitbucket.log.LoggingService;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.log.RestLogLevel;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Path(value="logs")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@AnonymousAllowed
public class LoggingResource {
    private final LoggingService loggingService;

    public LoggingResource(LoggingService loggingService) {
        this.loggingService = loggingService;
    }

    @Path(value="logger/{loggerName}")
    @GET
    public Response getLevel(@PathParam(value="loggerName") String loggerName) {
        String level = this.loggingService.getLevel(loggerName);
        return ResponseFactory.ok(new RestLogLevel(level)).build();
    }

    @Path(value="rootLogger")
    @GET
    public Response getRootLevel() {
        String level = this.loggingService.getRootLevel();
        return ResponseFactory.ok(new RestLogLevel(level)).build();
    }

    @Path(value="logger/{loggerName}/{levelName}")
    @PUT
    public Response setLevel(@PathParam(value="loggerName") String loggerName, @PathParam(value="levelName") String levelName) {
        try {
            this.loggingService.setLevel(loggerName, levelName);
            return ResponseFactory.noContent().build();
        }
        catch (IllegalArgumentException e) {
            throw this.translate(e);
        }
    }

    @Path(value="rootLogger/{levelName}")
    @PUT
    public Response setRootLevel(@PathParam(value="levelName") String levelName) {
        try {
            this.loggingService.setRootLevel(levelName);
            return ResponseFactory.noContent().build();
        }
        catch (IllegalArgumentException e) {
            throw this.translate(e);
        }
    }

    private BadRequestException translate(IllegalArgumentException e) {
        return new BadRequestException(e.getMessage());
    }
}

