/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.inject;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.stash.internal.rest.inject.AbstractResourceInjectable;
import com.atlassian.stash.internal.rest.util.HttpContextUtils;
import com.sun.jersey.api.core.HttpContext;
import javax.annotation.Nonnull;

public class UserInjectable
extends AbstractResourceInjectable<ApplicationUser> {
    private final I18nService i18nService;
    private final UserService userService;

    public UserInjectable(I18nService i18nService, UserService userService) {
        this.i18nService = i18nService;
        this.userService = userService;
    }

    @Override
    @Nonnull
    public ApplicationUser doGetValue(HttpContext httpContext) {
        String userSlug = HttpContextUtils.requireSinglePathSegmentValue("userSlug", httpContext, ApplicationUser.class);
        ApplicationUser user = this.userService.getUserByName(userSlug);
        if (user == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchuser", new Object[]{userSlug}), userSlug);
        }
        return user;
    }
}

