/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.exception;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.request.RequestMetadata;
import com.atlassian.bitbucket.rest.ResourceException;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.rest.exception.UnhandledExceptionMapperHelper;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.validation.FormValidationException;
import com.atlassian.stash.internal.rest.exception.ConstraintViolationExceptionMapper;
import com.atlassian.stash.internal.rest.exception.JsonParseExceptionMapper;
import com.atlassian.stash.internal.rest.exception.NoSuchEntityExceptionMapper;
import com.atlassian.stash.internal.rest.exception.ResourceContextInjectionFailedException;
import com.atlassian.stash.internal.rest.exception.ResourceExceptionMapper;
import com.atlassian.stash.internal.rest.exception.ServiceExceptionMapper;
import com.atlassian.stash.internal.rest.exception.UnrecognizedPropertyExceptionMapper;
import com.atlassian.stash.internal.rest.exception.ValidationExceptionMapper;
import com.atlassian.stash.internal.rest.exception.WebApplicationExceptionMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.exc.UnrecognizedPropertyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnhandledExceptionMapperHelper
implements UnhandledExceptionMapperHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultUnhandledExceptionMapperHelper.class);
    private final Map<Class<?>, ExceptionMapper<?>> mappers;
    private final RequestManager requestManager;

    public DefaultUnhandledExceptionMapperHelper(AuthenticationContext authenticationContext, I18nService i18nService, NavBuilder navBuilder, RequestManager requestManager) {
        this.requestManager = requestManager;
        this.mappers = ImmutableMap.builder().put(ServiceException.class, (Object)new ServiceExceptionMapper(navBuilder)).put(ConstraintViolationException.class, (Object)new ConstraintViolationExceptionMapper()).put(FormValidationException.class, (Object)new ValidationExceptionMapper()).put(JsonParseException.class, (Object)new JsonParseExceptionMapper()).put(NoSuchEntityException.class, (Object)new NoSuchEntityExceptionMapper(authenticationContext, i18nService)).put(ResourceException.class, (Object)new ResourceExceptionMapper()).put(UnrecognizedPropertyException.class, (Object)new UnrecognizedPropertyExceptionMapper()).put(WebApplicationException.class, (Object)new WebApplicationExceptionMapper()).build();
    }

    @Override
    @Nonnull
    public Response map(Exception exception) {
        if (exception instanceof ResourceContextInjectionFailedException && exception.getCause() instanceof Exception) {
            exception = (Exception)exception.getCause();
        }
        Class<?> exceptionClass = exception.getClass();
        while (!exceptionClass.equals(Exception.class)) {
            Response response;
            ExceptionMapper<?> mapper = this.mappers.get(exceptionClass);
            if (mapper != null && (response = mapper.toResponse((Throwable)exception)) != null) {
                return response;
            }
            exceptionClass = exceptionClass.getSuperclass();
        }
        RequestMetadata metadata = this.requestManager.getRequestMetadata();
        if (metadata == null) {
            log.error("Unhandled exception while processing REST request, but no request is active", (Throwable)exception);
        } else {
            log.error("Unhandled exception while processing REST request: {}", (Object)metadata.getAction(), (Object)exception);
        }
        return ResponseFactory.status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new RestErrors("An error occurred while processing the request. Check the server logs for more information.")).type("application/json;charset=UTF-8").build();
    }
}

