/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.enrich;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.enrich.LinkEnricher;
import com.atlassian.bitbucket.rest.project.RestProject;
import com.atlassian.bitbucket.rest.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.repository.RestRepository;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.util.RestNamedLink;
import com.atlassian.bitbucket.rest.util.RestRelatedLinks;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.bitbucket.user.ApplicationUser;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLinkEnricher
implements LinkEnricher {
    private static final Logger log = LoggerFactory.getLogger(DefaultLinkEnricher.class);
    private final NavBuilder navBuilder;
    private final RepositoryService repositoryService;

    public DefaultLinkEnricher(NavBuilder navBuilder, RepositoryService repositoryService) {
        this.navBuilder = navBuilder;
        this.repositoryService = repositoryService;
    }

    @Override
    public void enrich(@Nonnull Object entity) {
        RestUtils.processEntities(entity, new Function<Object, Object>(){

            @Override
            public Object apply(Object entity) {
                if (entity instanceof RestApplicationUser) {
                    DefaultLinkEnricher.this.enrichStashUser((RestApplicationUser)entity);
                } else if (entity instanceof RestRepository) {
                    DefaultLinkEnricher.this.enrichRepository((RestRepository)entity);
                } else if (entity instanceof RestProject) {
                    DefaultLinkEnricher.this.enrichProject((RestProject)entity);
                } else if (entity instanceof RestPullRequest) {
                    DefaultLinkEnricher.this.enrichPullRequest((RestPullRequest)entity);
                }
                return entity;
            }
        });
    }

    private void enrichPullRequest(RestPullRequest pullRequest) {
        RestRepository repository = pullRequest.getToRef().getRepository();
        String projectKey = repository.getProject().getKey();
        String slug = repository.getSlug();
        long id = pullRequest.getId();
        pullRequest.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", new RestNamedLink(this.navBuilder.project(projectKey).repo(slug).pullRequest(id).buildAbsolute())).build());
    }

    private void enrichProject(RestProject project) {
        project.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", new RestNamedLink(this.navBuilder.project((Project)project).buildAbsolute())).build());
    }

    private void enrichStashUser(RestApplicationUser person) {
        person.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", new RestNamedLink(this.navBuilder.user((ApplicationUser)person).buildAbsolute())).build());
    }

    private void enrichRepository(RestRepository restRepository) {
        NavBuilder.Repo repoNav = this.navBuilder.project(restRepository.getProject().getKey()).repo(restRepository.getSlug());
        RestRelatedLinks.Builder linkBuilder = new RestRelatedLinks.Builder().addRelatedLink("self", new RestNamedLink(repoNav.browse().buildAbsolute()));
        Repository repository = null;
        try {
            repository = this.repositoryService.getById(restRepository.getId());
            if (repository == null) {
                log.debug("Unable to enrich REST repository with ID {}: failed to look up repository", (Object)restRepository.getId());
            }
        }
        catch (AuthorisationException e) {
            log.debug("Skipping enrichment of REST repository with ID {} as it is not accessible to the current user", (Object)restRepository.getId());
        }
        catch (Exception e) {
            log.warn("Failed to enrich REST repository with ID {}: error while looking up repository", (Object)restRepository.getId(), (Object)e);
        }
        if (repository != null) {
            try {
                Set cloneLinks = this.repositoryService.getCloneLinks(new RepositoryCloneLinksRequest.Builder().repository(repository).build());
                cloneLinks.stream().map(RestNamedLink.REST_TRANSFORM).forEach(link -> linkBuilder.addRelatedLink("clone", (RestNamedLink)link));
            }
            catch (Exception e) {
                log.warn("Failed to enrich REST repository with ID {}: error while gathering clone links", (Object)restRepository.getId(), (Object)e);
            }
        }
        restRepository.setLinks(linkBuilder.build());
    }
}

