/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.bitbucket.content.AbstractFileContentCallback;
import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.content.FileContext;
import com.atlassian.bitbucket.content.FileSummary;
import com.atlassian.bitbucket.rest.content.RestBlame;
import com.atlassian.bitbucket.rest.content.RestPath;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class JsonFileContentCallback
extends AbstractFileContentCallback {
    private final Function<Blame, RestBlame> blameTransformer;
    private final RestPath path;
    private final StatefulJsonWriter writer;
    private boolean inLines;

    public JsonFileContentCallback(StatefulJsonWriter writer, RestPath path, Function<Blame, RestBlame> blameTransformer) {
        this.blameTransformer = blameTransformer;
        this.path = path;
        this.writer = writer;
    }

    public void offerBlame(@Nonnull List<Blame> blames) throws IOException {
        this.endLines();
        this.writer.name("blame").beginArray();
        for (Blame blame : blames) {
            this.writer.value(this.blameTransformer.apply(blame));
        }
        this.writer.endArray();
    }

    public void onBinary() throws IOException {
        this.writer.beginObject().name("binary").value(true).name("path").value(this.path).endObject();
    }

    public void onEnd(@Nonnull FileSummary summary) throws IOException {
        this.endLines();
        this.writer.name("start").value(summary.getPageRequest().getStart()).name("size").value(summary.getSize()).name("isLastPage").value(summary.isLastPage()).endObject();
    }

    public boolean onLine(int lineNumber, String line, boolean truncated) throws IOException {
        this.writer.beginObject().name("text").value(line);
        if (truncated) {
            this.writer.name("truncated").value(true);
        }
        this.writer.endObject();
        return true;
    }

    public void onStart(@Nonnull FileContext context) throws IOException {
        this.writer.beginObject().name("lines").beginArray();
        this.inLines = true;
    }

    private void endLines() throws IOException {
        if (this.inLines) {
            this.writer.endArray();
            this.inLines = false;
        }
    }
}

