/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.util.CachePolicies;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.content.JsonContentTreeCallback;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/files")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class FileListResource {
    private final ContentService contentService;
    private final I18nService i18nService;
    private final RefService refService;
    public static final RestPage<String> EXAMPLE = RestDocUtils.pageOf("path/to/file.txt");

    public FileListResource(ContentService contentService, I18nService i18nService, RefService refService) {
        this.contentService = contentService;
        this.i18nService = i18nService;
        this.refService = refService;
    }

    @GET
    @Path(value="{path:.*}")
    public Response listRepositoryFiles(final @Context Repository repository, final @PathParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="at") String at, final @Context PageRequest pageRequest) {
        final String objectId = RestUtils.getOrDefaultBranch(this.refService, repository, at);
        if (this.contentService.getType(repository, objectId, path) != ContentTreeNode.Type.DIRECTORY) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.filelist.not.directory", new Object[]{path, at}));
        }
        return ResponseFactory.ok(new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                FileListResource.this.contentService.streamDirectory(repository, objectId, path, true, (ContentTreeCallback)new JsonContentTreeCallback(writer), pageRequest);
            }
        }, CachePolicies.getCacheControlObjectId(at)).build();
    }

    @GET
    public Response listRepositoryFiles(@Context Repository repository, @QueryParam(value="at") @DefaultValue(value="") String at, @Context PageRequest pageRequest) {
        return this.listRepositoryFiles(repository, "", at, pageRequest);
    }
}

