/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.user.ExampleDetailedUser;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.user.RestPerson;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=PullRequestParticipant.class)
public class RestPullRequestParticipant
extends RestMapEntity {
    public static final Function<PullRequestParticipant, RestPullRequestParticipant> REST_TRANSFORM = RestPullRequestParticipant::new;
    public static final String USER = "user";
    public static final String ROLE = "role";
    public static final String APPROVED = "approved";
    private static final String STATUS = "status";
    public static final RestPullRequestParticipant REQUEST_EXAMPLE_ADD_REVIEWER = new RestPullRequestParticipant(RestApplicationUser.EXAMPLE_NAME_ONLY, PullRequestRole.REVIEWER, null);
    public static final RestPullRequestParticipant EXAMPLE_RESPONSE_REVIEWER_APPROVED = new RestPullRequestParticipant(RestApplicationUser.RESPONSE_EXAMPLE, PullRequestRole.REVIEWER, PullRequestParticipantStatus.APPROVED);
    public static final RestPullRequestParticipant EXAMPLE_RESPONSE_REVIEWER_UNAPPROVED = new RestPullRequestParticipant(RestApplicationUser.RESPONSE_EXAMPLE, PullRequestRole.REVIEWER, PullRequestParticipantStatus.UNAPPROVED);
    public static final RestPullRequestParticipant REQUEST_EXAMPLE_USER_ONLY = new RestPullRequestParticipant(RestApplicationUser.EXAMPLE_NAME_ONLY, null, null);
    public static final RestPullRequestParticipant REQUEST_EXAMPLE_REVIEWER = new RestPullRequestParticipant(RestApplicationUser.EXAMPLE_NAME_ONLY, PullRequestRole.REVIEWER, PullRequestParticipantStatus.UNAPPROVED);
    public static final RestPage<RestPullRequestParticipant> PAGE = RestDocUtils.pageOf(EXAMPLE_RESPONSE_REVIEWER_APPROVED);

    public RestPullRequestParticipant() {
    }

    public RestPullRequestParticipant(PullRequestParticipant participant) {
        this(new RestApplicationUser(participant.getUser()), participant.getRole(), participant.getStatus());
    }

    public RestPullRequestParticipant(Map<String, Object> values) {
        super(values);
    }

    private RestPullRequestParticipant(RestPerson user, PullRequestRole role, PullRequestParticipantStatus status) {
        this.putIfNotNull(USER, user);
        this.putIfNotNull(ROLE, role);
        if (status != null) {
            this.put(APPROVED, status == PullRequestParticipantStatus.APPROVED);
            this.put(STATUS, status);
        }
    }

    public PullRequestRole getRole() {
        return this.getEnumProperty(ROLE, PullRequestRole.class);
    }

    public PullRequestParticipantStatus getStatus() {
        return this.getEnumProperty(STATUS, PullRequestParticipantStatus.class);
    }

    public RestApplicationUser getUser() {
        return RestApplicationUser.valueOf(this.get(USER));
    }

    @Nullable
    public static RestPullRequestParticipant valueOf(@Nullable Object value) {
        if (value instanceof RestPullRequestParticipant) {
            return (RestPullRequestParticipant)value;
        }
        if (value instanceof Map) {
            return new RestPullRequestParticipant((Map)value);
        }
        return null;
    }

    @Deprecated
    @Nonnull
    public static RestPullRequestParticipant newExample(@Nullable String name, @Nullable PullRequestRole role, @Nullable Boolean approved) {
        if (approved == null) {
            return RestPullRequestParticipant.newExample(name, role, (PullRequestParticipantStatus)null);
        }
        return RestPullRequestParticipant.newExample(name, role, approved != false ? PullRequestParticipantStatus.APPROVED : PullRequestParticipantStatus.UNAPPROVED);
    }

    @Nonnull
    public static RestPullRequestParticipant newExample(@Nullable String name, @Nullable PullRequestRole role, @Nullable PullRequestParticipantStatus status) {
        ExampleDetailedUser exampleUser = ExampleDetailedUser.newExample(name);
        return new RestPullRequestParticipant(new RestApplicationUser((ApplicationUser)exampleUser), role, status);
    }
}

