/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.content;

import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.File;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.content.RestContentTreeNode;
import com.atlassian.bitbucket.rest.content.RestPath;
import java.util.OptionalLong;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=File.class)
public class RestFile
extends RestMapEntity
implements RestContentTreeNode {
    public static final RestFile EXAMPLE = new RestFile(RestPath.EXAMPLE, "addcbdab1ddd9245f97d4461f6bdf2c0f3724880", OptionalLong.of(24067L));

    public RestFile(File file) {
        this(RestPath.fromPath(file.getPath()), file.getContentId(), file.getSize());
    }

    @Deprecated
    public RestFile(RestPath path, String contentId) {
        this(path, contentId, OptionalLong.empty());
    }

    private RestFile(RestPath path, String contentId, OptionalLong size) {
        this.put("path", path);
        this.put("contentId", contentId);
        this.put("type", ContentTreeNode.Type.FILE);
        size.ifPresent(value -> this.put("size", value));
    }
}

