/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.content;

import com.atlassian.bitbucket.content.Diff;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.comment.RestComment;
import com.atlassian.bitbucket.rest.content.RestDiffHunk;
import com.atlassian.bitbucket.rest.content.RestPath;
import com.atlassian.bitbucket.rest.property.RestPropertySupport;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Diff.class)
public class RestDiff
extends RestPropertySupport {
    public static final Function<Diff, RestDiff> REST_TRANSFORM = RestDiff::new;
    public static final RestDiff EXAMPLE = RestDiff.enrichTopLevel(new RestDiff(RestPath.EXAMPLE, RestPath.EXAMPLE, false, Lists.newArrayList((Object[])new RestDiffHunk[]{RestDiffHunk.HUNKY_EXAMPLE}), null, false, null));
    public static final RestDiff EXAMPLE_COMMENT = RestDiff.enrichTopLevel(new RestDiff(RestPath.EXAMPLE, RestPath.EXAMPLE, false, Lists.newArrayList((Object[])new RestDiffHunk[]{RestDiffHunk.HUNKY_EXAMPLE_COMMENTED}), Lists.newArrayList((Object[])new RestComment[]{RestComment.RESPONSE_EXAMPLE_NO_REPLY}), false, null));
    public static final RestMapEntity PAGE_EXAMPLE = RestDiff.enrichTopLevel(RestDocUtils.wrap(Collections.singletonList(EXAMPLE), "diffs"));
    public static final RestMapEntity PAGE_WITH_COMMENTS_EXAMPLE = RestDiff.enrichTopLevel(RestDocUtils.wrap(Collections.singletonList(EXAMPLE_COMMENT), "diffs"));

    public RestDiff() {
    }

    public RestDiff(Diff diff) {
        this(RestPath.fromPath(diff.getSource()), RestPath.fromPath(diff.getDestination()), diff.isBinary(), diff.isBinary() ? null : RestDiff.transform(diff.getHunks(), RestDiffHunk.REST_TRANSFORM), null, diff.isTruncated(), diff.getProperties());
    }

    private RestDiff(RestPath source, RestPath destination, boolean isBinary, Iterable<RestDiffHunk> hunks, Iterable<RestComment> lineComments, boolean isTruncated, PropertyMap properties) {
        this.put("source", source);
        this.put("destination", destination);
        if (isBinary) {
            this.put("binary", true);
        } else {
            this.put("hunks", hunks);
            this.putIfNotEmpty("lineComments", lineComments);
            this.putIfNotNull("truncated", isTruncated);
            this.putProperties((Map<String, Object>)properties);
        }
    }

    private static <T extends RestMapEntity> T enrichTopLevel(T entity) {
        return RestDocUtils.decorate(entity, ImmutableMap.of((Object)"truncated", (Object)"true", (Object)"contextLines", (Object)"10", (Object)"fromHash", (Object)"a0f224fd7bd5f28ea5a752d41b9c9f6372fc6d9e", (Object)"toHash", (Object)"dc93f22caadcde35daf5cc2cd65d2738c87e31ca", (Object)"whiteSpace", (Object)"SHOW"));
    }
}

