/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.bitbucket.auth.IncorrectPasswordAuthenticationException;
import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestNamedLink;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.UserSearchRequest;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartConfigClass;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.stash.internal.rest.avatar.AvatarMultipartConfig;
import com.atlassian.stash.internal.rest.avatar.FilePartAvatarSupplier;
import com.atlassian.stash.internal.rest.user.CommonJsonObjects;
import com.atlassian.stash.internal.rest.user.RestUserSearchRequestParser;
import com.atlassian.stash.internal.rest.user.Validators;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import java.net.URI;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="users")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class UserResource
extends RestResource {
    private static final String AVATAR_PATH = "{userSlug}/avatar.png";
    private final AvatarService avatarService;
    private final RestUserSearchRequestParser userSearchRequestParser;
    private final UserService userService;
    private final Validator validator;
    private static final RestNamedLink DELETE_AVATAR_EXAMPLE = new RestNamedLink("http://www.gravatar.com/avatar/aa99b351245441b8ca95d54a52d2998c");

    public UserResource(AvatarService avatarService, I18nService i18nService, UserService userService, RestUserSearchRequestParser userSearchRequestParser, Validator validator) {
        super(i18nService);
        this.avatarService = avatarService;
        this.userSearchRequestParser = userSearchRequestParser;
        this.userService = userService;
        this.validator = validator;
    }

    @DELETE
    @Path(value="{userSlug}/avatar.png")
    public Response deleteAvatar(@Context ApplicationUser user, @Context ContainerRequest request) {
        this.userService.deleteAvatar(user);
        String avatarUrl = this.avatarService.getUrlForPerson((Person)user, new AvatarRequest(request.isSecure(), 256, true));
        return ResponseFactory.ok(new RestNamedLink(avatarUrl)).build();
    }

    @GET
    @Path(value="{userSlug}")
    public Response getUser(@Context ApplicationUser user) {
        return ResponseFactory.ok(RestApplicationUser.REST_TRANSFORM.apply((Object)user)).build();
    }

    @GET
    public Response getUsers(@Context UriInfo uriInfo, @Context PageRequest pageRequest) {
        UserSearchRequest searchRequest = this.userSearchRequestParser.parse((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        Page users = this.userService.search(searchRequest, pageRequest);
        return ResponseFactory.ok(new RestPage<RestApplicationUser>(users, RestApplicationUser.REST_TRANSFORM)).build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @MultipartConfigClass(value=AvatarMultipartConfig.class)
    @Path(value="{userSlug}/avatar.png")
    @RequiresXsrfCheck
    public Response uploadAvatar(@Context ApplicationUser user, @Context UriInfo uriInfo, @MultipartFormParam(value="avatar") FilePart file) {
        this.userService.updateAvatar(user, (AvatarSupplier)new FilePartAvatarSupplier(file));
        return Response.created((URI)uriInfo.getRequestUri()).build();
    }

    @PUT
    public Response updateUserDetails(CommonJsonObjects.UserUpdate u) {
        CommonJsonObjects.UserUpdate update = this.trimFields(u);
        Validators.validateConstraints(this.validator, update);
        ApplicationUser user = this.userService.updateUser(update.getDisplayName(), update.getEmail());
        return ResponseFactory.ok(new RestApplicationUser(user)).build();
    }

    @PUT
    @Path(value="credentials")
    public Response updateUserPassword(CommonJsonObjects.UserPasswordUpdate update) {
        Validators.validateConstraints(this.validator, update);
        try {
            this.userService.updatePassword(update.getOldPassword(), update.getPassword());
            return ResponseFactory.noContent().build();
        }
        catch (IncorrectPasswordAuthenticationException e) {
            return Validators.reportAsConstraintViolation(update, "oldPassword", e.getLocalizedMessage());
        }
    }

    private CommonJsonObjects.UserUpdate trimFields(CommonJsonObjects.UserUpdate update) {
        return new CommonJsonObjects.UserUpdate(StringUtils.trimToNull((String)update.getName()), StringUtils.trimToNull((String)update.getDisplayName()), StringUtils.trimToNull((String)update.getEmail()));
    }
}

