/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestTaskSearchRequest;
import com.atlassian.bitbucket.rest.task.RestTask;
import com.atlassian.bitbucket.rest.task.RestTaskCount;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.task.TaskCount;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/tasks")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class PullRequestTaskResource {
    private final PullRequestService pullRequestService;

    public PullRequestTaskResource(PullRequestService pullRequestService) {
        this.pullRequestService = pullRequestService;
    }

    @GET
    @Path(value="count")
    public Response countPullRequestTasks(@Context PullRequest pullRequest) {
        TaskCount taskCount = this.pullRequestService.countTasks(new PullRequestTaskSearchRequest.Builder(pullRequest).build());
        return ResponseFactory.ok().entity(RestTaskCount.REST_TRANSFORM.apply((Object)taskCount)).build();
    }

    @GET
    public Response getPullRequestTasks(@Context PullRequest pullRequest, @Context PageRequest pageRequest) {
        Page page = this.pullRequestService.searchTasks(new PullRequestTaskSearchRequest.Builder(pullRequest).build(), pageRequest);
        return ResponseFactory.ok(new RestPage<RestTask>(page, RestTask.REST_TRANSFORM)).build();
    }
}

