/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.inject;

import com.atlassian.stash.internal.rest.annotations.OptionalBody;
import com.atlassian.stash.internal.rest.inject.AbstractResourceInjectable;
import com.sun.jersey.api.container.MappableContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.provider.EntityHolder;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;

public class OptionalBodyInjectableProvider
implements InjectableProvider<OptionalBody, Type> {
    public Injectable getInjectable(ComponentContext ic, OptionalBody optionalBody, Type type) {
        ParameterizedType genericType;
        if (type instanceof ParameterizedType && EntityHolder.class.equals((Object)(genericType = (ParameterizedType)type).getRawType())) {
            return new OptionalBodyInjectable(genericType);
        }
        return null;
    }

    public ComponentScope getScope() {
        return ComponentScope.Singleton;
    }

    private static class OptionalBodyInjectable
    extends AbstractResourceInjectable<EntityHolder> {
        private final Type genericType;

        private OptionalBodyInjectable(Type genericType) {
            this.genericType = genericType;
        }

        @Override
        protected EntityHolder doGetValue(HttpContext context) {
            ContainerRequest request = (ContainerRequest)context.getRequest();
            MediaType mediaType = request.getMediaType();
            if (mediaType == null) {
                mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
            MessageBodyReader reader = request.getMessageBodyWorkers().getMessageBodyReader(EntityHolder.class, this.genericType, EMPTY_ANNOTATIONS, MediaType.WILDCARD_TYPE);
            try {
                return (EntityHolder)reader.readFrom(EntityHolder.class, this.genericType, EMPTY_ANNOTATIONS, mediaType, request.getRequestHeaders(), request.getEntityInputStream());
            }
            catch (IOException e) {
                throw new MappableContainerException((Throwable)e);
            }
        }
    }
}

