/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.enrich;

import com.atlassian.bitbucket.markup.MarkupService;
import com.atlassian.bitbucket.markup.RenderContext;
import com.atlassian.bitbucket.rest.comment.RestComment;
import com.atlassian.bitbucket.rest.enrich.MarkupEnricher;
import com.atlassian.bitbucket.rest.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class DefaultMarkupEnricher
implements MarkupEnricher {
    private static final RenderContext CONTEXT = new RenderContext.Builder().build();
    private final MarkupService markupService;

    public DefaultMarkupEnricher(MarkupService markupService) {
        this.markupService = markupService;
    }

    @Override
    @Nonnull
    public Object enrich(@Nonnull Object entity) {
        return RestUtils.processEntities(entity, new Function<Object, Object>(){

            public Object apply(Object entity) {
                if (entity instanceof RestComment) {
                    RestComment comment = (RestComment)entity;
                    comment.setHtml(DefaultMarkupEnricher.this.render(comment.getText()));
                } else if (entity instanceof RestPullRequest) {
                    RestPullRequest pullRequest = (RestPullRequest)entity;
                    pullRequest.setHtmlDescription(DefaultMarkupEnricher.this.render(pullRequest.getDescription()));
                }
                return entity;
            }
        });
    }

    private String render(String text) {
        return StringUtils.isEmpty((String)text) ? text : this.markupService.render(text, CONTEXT);
    }
}

