/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.bitbucket.content.AbstractChangeCallback;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeContext;
import com.atlassian.bitbucket.content.ChangeSummary;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.rest.content.RestChange;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import java.io.IOException;
import javax.annotation.Nonnull;

public class JsonChangeCallback
extends AbstractChangeCallback {
    private final NavBuilder.Commit commitNav;
    private final PageRequest pageRequest;
    private final StatefulJsonWriter writer;
    private boolean ended;
    private int received;
    private int written;

    public JsonChangeCallback(StatefulJsonWriter writer, PageRequest pageRequest) {
        this(writer, pageRequest, null);
    }

    public JsonChangeCallback(StatefulJsonWriter writer, PageRequest pageRequest, NavBuilder.Commit commitNav) {
        this.commitNav = commitNav;
        this.pageRequest = pageRequest;
        this.writer = writer;
    }

    public boolean onChange(@Nonnull Change change) throws IOException {
        if (this.received++ < this.pageRequest.getStart()) {
            return true;
        }
        if (this.written == this.pageRequest.getLimit()) {
            this.endPage(false);
            return false;
        }
        this.writer.value(new RestChange(change, this.commitNav));
        ++this.written;
        return true;
    }

    public void onEnd(@Nonnull ChangeSummary summary) throws IOException {
        this.endPage(!summary.isTruncated());
    }

    public void onStart(@Nonnull ChangeContext context) throws IOException {
        this.writer.beginObject().name("fromHash").value(context.getFromHash()).name("toHash").value(context.getToHash()).name("values").beginArray();
    }

    private void endPage(boolean lastPage) throws IOException {
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.writer.endArray().name("size").value(this.written).name("isLastPage").value(lastPage).name("start").value(this.pageRequest.getStart()).name("limit").value(this.pageRequest.getLimit()).name("nextPageStart");
        if (lastPage) {
            this.writer.nullValue();
        } else {
            this.writer.value(this.pageRequest.getStart() + this.pageRequest.getLimit());
        }
        this.writer.endObject();
    }
}

