/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffRequest;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.comment.RestComment;
import com.atlassian.bitbucket.rest.util.CachePolicies;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.content.JsonDiffContentCallback;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/diff")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class DiffResource
extends RestResource {
    private final CommitService commitService;

    public DiffResource(I18nService i18nService, CommitService commitService) {
        super(i18nService);
        this.commitService = commitService;
    }

    @GET
    @Path(value="{path:.*}")
    public Response streamDiff(@Context Repository repository, @PathParam(value="path") String path, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="until") String untilId, @QueryParam(value="whitespace") String whitespace) {
        if (StringUtils.isBlank((String)path)) {
            throw new BadRequestException(this.i18nService.getMessage("stash.rest.diff.path.required", new Object[0]));
        }
        if (StringUtils.isBlank((String)untilId)) {
            throw new BadRequestException(this.i18nService.getMessage("stash.rest.diff.until.required", new Object[0]));
        }
        DiffRequest.Builder builder = new DiffRequest.Builder(repository, untilId).contextLines(contextLines).path(path).sinceId(sinceId).whitespace(DiffWhitespace.fromString((String)whitespace)).withComments(false);
        if (StringUtils.isNotBlank((String)srcPath)) {
            builder.path(srcPath);
        }
        final DiffRequest diffRequest = builder.build();
        return ResponseFactory.ok(new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                DiffResource.this.commitService.streamDiff(diffRequest, (DiffContentCallback)new JsonDiffContentCallback(writer, RestComment.REST_TRANSFORM));
            }
        }, CachePolicies.getCacheControlForRange(untilId, sinceId)).build();
    }

    @GET
    public Response streamDiff(@Context Repository repository, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="until") String untilId, @QueryParam(value="whitespace") String whitespace) {
        return this.streamDiff(repository, null, contextLines, sinceId, srcPath, untilId, whitespace);
    }
}

