/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.content.AbstractContentTreeCallback;
import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.ContentTreeSummary;
import com.atlassian.bitbucket.content.Directory;
import com.atlassian.bitbucket.content.File;
import com.atlassian.bitbucket.content.FileContentCallback;
import com.atlassian.bitbucket.content.Submodule;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.content.RestBlame;
import com.atlassian.bitbucket.rest.content.RestContentTreeNode;
import com.atlassian.bitbucket.rest.content.RestDirectory;
import com.atlassian.bitbucket.rest.content.RestDirectoryRevision;
import com.atlassian.bitbucket.rest.content.RestFile;
import com.atlassian.bitbucket.rest.content.RestPath;
import com.atlassian.bitbucket.rest.content.RestSubmodule;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.enrich.LinkEnricher;
import com.atlassian.bitbucket.rest.util.CachePolicies;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.content.JsonFileContentCallback;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/browse")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class ContentResource {
    private final AvatarEnricher avatarEnricher;
    private final ContentService contentService;
    private final LinkEnricher linkEnricher;
    private final RefService refService;
    public static final RestPage<Map<String, Object>> EXAMPLE;

    public ContentResource(AvatarEnricher avatarEnricher, ContentService contentService, LinkEnricher linkEnricher, RefService refService) {
        this.avatarEnricher = avatarEnricher;
        this.contentService = contentService;
        this.linkEnricher = linkEnricher;
        this.refService = refService;
    }

    @GET
    @Path(value="{path:.*}")
    public Response getContent(@Context Repository repository, @QueryParam(value="at") @DefaultValue(value="") String at, @PathParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="type") @DefaultValue(value="false") boolean type, @QueryParam(value="blame") String blame, @QueryParam(value="noContent") String noContent, @Context ContainerRequest request) {
        boolean showBlame;
        at = RestUtils.getOrDefaultBranch(this.refService, repository, at);
        CacheControl cacheControl = CachePolicies.getCacheControlObjectId(at);
        ContentTreeNode.Type nodeType = this.contentService.getType(repository, at, path);
        if (type) {
            return ResponseFactory.ok(new RestContentTreeNode.RestType(nodeType), cacheControl).build();
        }
        PageRequest pageRequest = RestUtils.makePageRequest((HttpRequestContext)request, 500);
        if (nodeType == ContentTreeNode.Type.DIRECTORY) {
            return ResponseFactory.ok(this.getDirectory(repository, at, path, pageRequest), cacheControl).build();
        }
        boolean bl = showBlame = blame != null && !"false".equalsIgnoreCase(blame);
        if (showBlame && noContent != null) {
            return ResponseFactory.ok(this.getBlame(repository, at, path, pageRequest), cacheControl).build();
        }
        AvatarRequest avatarRequest = null;
        if (showBlame) {
            avatarRequest = RestUtils.makeAvatarRequest(request);
        }
        return ResponseFactory.ok(this.getFile(repository, at, path, avatarRequest, pageRequest, showBlame), cacheControl).build();
    }

    @GET
    public Response getContent(@Context Repository repository, @QueryParam(value="at") @DefaultValue(value="") String objectId, @QueryParam(value="type") @DefaultValue(value="false") boolean typeOnly, @QueryParam(value="blame") String withBlame, @QueryParam(value="noContent") String noContent, @Context ContainerRequest request) {
        return this.getContent(repository, objectId, "", typeOnly, withBlame, noContent, request);
    }

    private Collection<RestBlame> getBlame(Repository repository, String objectId, String path, PageRequest pageRequest) {
        return ImmutableList.copyOf((Collection)Collections2.transform((Collection)this.contentService.getBlame(repository, objectId, path, pageRequest), RestBlame.REST_TRANSFORM));
    }

    private RestDirectoryRevision getDirectory(Repository repository, String commitId, String path, PageRequest pageRequest) {
        final ArrayList nodes = Lists.newArrayList();
        final ContentTreeSummary[] summaryRef = new ContentTreeSummary[1];
        this.contentService.streamDirectory(repository, commitId, path, false, (ContentTreeCallback)new AbstractContentTreeCallback(){

            public void onEnd(@Nonnull ContentTreeSummary summary) {
                summaryRef[0] = summary;
            }

            public boolean onTreeNode(@Nonnull ContentTreeNode node) {
                if (node.getType() == ContentTreeNode.Type.DIRECTORY) {
                    nodes.add(new RestDirectory((Directory)node));
                } else if (node.getType() == ContentTreeNode.Type.SUBMODULE) {
                    nodes.add(new RestSubmodule((Submodule)node));
                } else {
                    nodes.add(new RestFile((File)node));
                }
                return true;
            }
        }, pageRequest);
        ContentTreeSummary summary = summaryRef[0];
        return new RestDirectoryRevision(new RestPath(path), commitId, new RestPage<RestContentTreeNode>(summary.getPageRequest().getStart(), summary.getPageRequest().getLimit(), summary.getSize(), summary.isLastPage(), nodes, summary.getNextPageRequest()));
    }

    private StreamingOutput getFile(final Repository repository, final String objectId, final String path, final AvatarRequest avatarRequest, final PageRequest pageRequest, final boolean withBlame) {
        final Function transformer = withBlame ? Functions.compose((Function)new Function<RestBlame, RestBlame>(){

            public RestBlame apply(RestBlame blame) {
                ContentResource.this.linkEnricher.enrich(blame);
                return blame;
            }
        }, (Function)(avatarRequest == null ? RestBlame.REST_TRANSFORM : new Function<Blame, RestBlame>(){

            public RestBlame apply(Blame input) {
                RestBlame blame = new RestBlame(input);
                ContentResource.this.avatarEnricher.enrich(blame, avatarRequest);
                return blame;
            }
        })) : null;
        return new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                ContentResource.this.contentService.streamFile(repository, objectId, path, pageRequest, withBlame, (FileContentCallback)new JsonFileContentCallback(writer, new RestPath(path), (Function<Blame, RestBlame>)transformer));
            }
        };
    }

    static {
        LinkedHashMap<String, String> line = new LinkedHashMap<String, String>();
        line.put("text", "print('hello world')");
        EXAMPLE = RestDocUtils.pageOf(line);
        EXAMPLE.put("lines", EXAMPLE.get("values"));
        EXAMPLE.remove("values");
    }
}

