/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.annotation.SecondaryRepository;
import com.atlassian.bitbucket.rest.commit.RestCommit;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.enrich.LinkEnricher;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.pull.JsonCommitCallback;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class CommitResource {
    private final AvatarEnricher avatarEnricher;
    private final CommitService commitService;
    private final LinkEnricher linkEnricher;
    private final RefService refService;

    public CommitResource(AvatarEnricher avatarEnricher, CommitService commitService, LinkEnricher linkEnricher, RefService refService) {
        this.avatarEnricher = avatarEnricher;
        this.commitService = commitService;
        this.linkEnricher = linkEnricher;
        this.refService = refService;
    }

    @GET
    public Response getCommits(final @Context Repository repository, final @QueryParam(value="path") String path, final @QueryParam(value="since") String parentId, @QueryParam(value="until") String commitId, final @QueryParam(value="withCounts") @DefaultValue(value="false") boolean withCounts, final @Context PageRequest pageRequest, @Context ContainerRequest request, final @SecondaryRepository Repository secondaryRepository) {
        final String untilOrAt = this.chooseInclude(repository, commitId);
        final Function commitTransformer = Functions.compose((Function)new Function<RestCommit, RestCommit>(){

            public RestCommit apply(RestCommit commit) {
                CommitResource.this.linkEnricher.enrich(commit);
                return commit;
            }
        }, RestCommit.createTransformer(request, this.avatarEnricher));
        return ResponseFactory.ok(new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                CommitsBetweenRequest request = new CommitsBetweenRequest.Builder(repository).include(untilOrAt, new String[0]).exclude(parentId, new String[0]).path(path).secondaryRepository(secondaryRepository).build();
                CommitResource.this.commitService.streamCommitsBetween(request, (CommitCallback)new JsonCommitCallback(writer, (Function<Commit, RestCommit>)commitTransformer, withCounts, pageRequest));
            }
        }).build();
    }

    @GET
    @Path(value="{commitId}")
    public Response getCommit(@Context Repository repository, @PathParam(value="commitId") String commitId, @QueryParam(value="path") String path) {
        Commit commit = this.commitService.getCommit(new CommitRequest.Builder(repository, commitId).path(path).build());
        return ResponseFactory.ok(new RestCommit(commit)).build();
    }

    private String chooseInclude(Repository repository, String commitId) {
        if (StringUtils.isBlank((String)commitId)) {
            commitId = this.refService.getDefaultBranch(repository).getLatestCommit();
        }
        return commitId;
    }
}

