/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.comment;

import com.atlassian.bitbucket.comment.AbstractAddCommentRequest;
import com.atlassian.bitbucket.comment.AddDiffCommentRequest;
import com.atlassian.bitbucket.comment.AddFileCommentRequest;
import com.atlassian.bitbucket.comment.DiffCommentAnchor;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.content.RestPath;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.google.common.base.Function;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.ws.rs.WebApplicationException;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=DiffCommentAnchor.class)
public class RestDiffCommentAnchor
extends RestMapEntity {
    public static final String LINE = "line";
    public static final String LINE_TYPE = "lineType";
    public static final String FILE_TYPE = "fileType";
    public static final Function<DiffCommentAnchor, RestDiffCommentAnchor> REST_TRANSFORM = new Function<DiffCommentAnchor, RestDiffCommentAnchor>(){

        public RestDiffCommentAnchor apply(DiffCommentAnchor anchor) {
            return new RestDiffCommentAnchor(anchor);
        }
    };
    public static final RestDiffCommentAnchor LINE_REQUEST_MINIMUM_EXAMPLE = new RestDiffCommentAnchor(null, null, "path/to/file", "path/to/file", 1, DiffSegmentType.CONTEXT, DiffFileType.FROM);

    public RestDiffCommentAnchor() {
    }

    public RestDiffCommentAnchor(Map<String, Object> values) {
        super(values);
    }

    public RestDiffCommentAnchor(DiffCommentAnchor anchor) {
        this(anchor.getFromHash(), anchor.getToHash(), anchor.getPath(), anchor.getSrcPath(), anchor.isLineComment() ? Integer.valueOf(anchor.getLine()) : null, anchor.isLineComment() ? anchor.getLineType() : null, anchor.isLineComment() ? anchor.getFileType() : null);
    }

    protected RestDiffCommentAnchor(String fromHash, String toHash, String path, String srcPath, Integer line, DiffSegmentType lineType, DiffFileType fileType) {
        this(fromHash, toHash, line, lineType, fileType);
        this.putIfNotNull("path", path);
        this.putIfNotNull("srcPath", srcPath);
    }

    protected RestDiffCommentAnchor(String fromHash, String toHash, Integer line, DiffSegmentType lineType, DiffFileType fileType) {
        this.putIfNotNull("fromHash", fromHash);
        this.putIfNotNull("toHash", toHash);
        this.putIfNotNull(LINE, line);
        this.putIfNotNull(LINE_TYPE, lineType);
        this.putIfNotNull(FILE_TYPE, fileType);
    }

    public DiffFileType getFileType() {
        return this.getEnumProperty(FILE_TYPE, DiffFileType.class);
    }

    public int getLine() {
        return this.getIntProperty(LINE);
    }

    public DiffSegmentType getLineType() {
        return this.getEnumProperty(LINE_TYPE, DiffSegmentType.class);
    }

    public RestPath getPath() {
        return this.getPathProperty("path");
    }

    public RestPath getSrcPath() {
        return this.getPathProperty("srcPath");
    }

    public boolean hasSrcPath() {
        return this.containsKey("srcPath");
    }

    public boolean isLineComment() {
        return this.containsKey(LINE) && this.containsKey(LINE_TYPE);
    }

    public AddFileCommentRequest.Builder toFile(@Nonnull I18nService i18nService) {
        return this.addPaths(new AddFileCommentRequest.Builder());
    }

    public AddDiffCommentRequest.Builder toLine(@Nonnull I18nService i18nService) {
        DiffFileType fileType;
        DiffSegmentType lineType;
        int line = this.getLine();
        if (line < 0) {
            throw new WebApplicationException(ResponseFactory.badRequest("anchor.line", i18nService.getMessage("stash.rest.comment.anchor.line.invalid", new Object[]{line})).build());
        }
        try {
            lineType = this.getLineType();
            if (lineType == null) {
                throw new WebApplicationException(ResponseFactory.badRequest("anchor.lineType", i18nService.getMessage("stash.rest.commit.comment.anchor.lineType.empty", new Object[0])).build());
            }
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(ResponseFactory.badRequest("anchor.lineType", i18nService.getMessage("stash.rest.commit.comment.anchor.lineType.invalid", new Object[]{this.get(LINE_TYPE)})).build());
        }
        try {
            fileType = this.getFileType();
            if (fileType == null) {
                fileType = DiffFileType.forSegmentType((DiffSegmentType)lineType);
                this.put(FILE_TYPE, fileType.name());
            }
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(ResponseFactory.badRequest("anchor.fileType", i18nService.getMessage("stash.rest.commit.comment.anchor.fileType.invalid", new Object[]{this.get(FILE_TYPE)})).build());
        }
        return this.addPaths(new AddDiffCommentRequest.Builder().fileType(fileType).line(line).lineType(lineType));
    }

    private <B extends AbstractAddCommentRequest.AbstractBuilder<B, ?>> B addPaths(B builder) {
        RestPath srcPath = this.getSrcPath();
        return (B)builder.path(this.getPath().toString()).srcPath(srcPath == null ? null : srcPath.toString());
    }
}

