/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.commit;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.commit.RestMinimalCommit;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarRequestHelper;
import com.atlassian.bitbucket.rest.v2.api.user.RestPerson;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerRequestContext;

@JsonSerialize
@JsonSurrogate(value=Commit.class)
public class RestCommit
extends RestMinimalCommit {
    public static final Function<Commit, RestCommit> REST_TRANSFORM = RestCommit::new;
    private static final String AUTHOR = "author";
    private static final String AUTHOR_TIMESTAMP = "authorTimestamp";
    private static final String COMMITTER = "committer";
    private static final String COMMITTER_TIMESTAMP = "committerTimestamp";
    private static final String MESSAGE = "message";
    private static final String PARENTS = "parents";
    private static final String PROPERTIES = "properties";

    public RestCommit(Commit commit) {
        super(commit.getId(), commit.getDisplayId());
        this.put(AUTHOR, RestPerson.REST_TRANSFORM.apply(commit.getAuthor()));
        this.put(AUTHOR_TIMESTAMP, commit.getAuthorTimestamp());
        this.put(COMMITTER, RestPerson.REST_TRANSFORM.apply(commit.getCommitter()));
        this.put(COMMITTER_TIMESTAMP, commit.getCommitterTimestamp());
        this.put(MESSAGE, commit.getMessage());
        this.put(PARENTS, ImmutableList.copyOf(RestMapEntity.transform(commit.getParents(), RestMinimalCommit.REST_TRANSFORM)));
        this.putIfNotEmpty(PROPERTIES, (Map<?, ?>)commit.getProperties());
    }

    private RestCommit(Map<String, Object> values) {
        super(values);
    }

    public RestPerson getAuthor() {
        return (RestPerson)this.get(AUTHOR);
    }

    @Schema(example="1359075920")
    public long getAuthorTimestamp() {
        return this.getLongProperty(AUTHOR_TIMESTAMP);
    }

    public RestPerson getCommitter() {
        return (RestPerson)this.get(COMMITTER);
    }

    @Schema(example="1449075830")
    public long getCommitterTimestamp() {
        return this.getLongProperty(COMMITTER_TIMESTAMP);
    }

    @Schema(example="More work on feature 1")
    public String getMessage() {
        return this.getStringProperty(MESSAGE);
    }

    @ArraySchema(schema=@Schema(implementation=RestMinimalCommit.class))
    public Collection<RestMinimalCommit> getParents() {
        return (Collection)this.get(PARENTS);
    }

    public static Function<Commit, RestCommit> createTransformer(@Nonnull ContainerRequestContext request, @Nonnull AvatarEnricher avatarEnricher, @Nonnull I18nService i18nService) {
        AvatarRequest avatarRequest = AvatarRequestHelper.makeAvatarRequest(request, i18nService);
        if (avatarRequest == null) {
            return REST_TRANSFORM;
        }
        return commit -> {
            RestCommit restCommit = new RestCommit((Commit)commit);
            avatarEnricher.enrich(restCommit, avatarRequest);
            return restCommit;
        };
    }

    @Deprecated
    public static Function<Commit, RestCommit> createTransformer(@Nonnull ContainerRequestContext request, @Nonnull AvatarEnricher avatarEnricher) {
        AvatarRequest avatarRequest = AvatarRequestHelper.makeAvatarRequest(request);
        if (avatarRequest == null) {
            return REST_TRANSFORM;
        }
        return commit -> {
            RestCommit restCommit = new RestCommit((Commit)commit);
            avatarEnricher.enrich(restCommit, avatarRequest);
            return restCommit;
        };
    }

    @Nullable
    public static RestCommit valueOf(Object value) {
        if (value instanceof RestCommit) {
            return (RestCommit)value;
        }
        if (value instanceof Map) {
            return new RestCommit((Map)value);
        }
        return null;
    }
}

