/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import javax.annotation.Nullable;

@JsonSerialize
@JsonSurrogate(value=ServiceException.class)
public class RestErrorMessage
extends RestMapEntity {
    private static final String CONTEXT = "context";
    private static final String EXCEPTION_NAME = "exceptionName";
    private static final String MESSAGE = "message";

    public RestErrorMessage(Map<String, Object> values) {
        this.putAll(values);
    }

    public RestErrorMessage(String context, String message) {
        this(context, message, null);
    }

    public RestErrorMessage(String context, String message, String exceptionName) {
        this.putIfNotNull(CONTEXT, context);
        this.putIfNotNull(MESSAGE, message);
        this.putIfNotNull(EXCEPTION_NAME, exceptionName);
    }

    public RestErrorMessage(String message) {
        this(null, message, null);
    }

    public RestErrorMessage(ServiceException e) {
        this(null, e.getLocalizedMessage(), e.getClass().getCanonicalName());
    }

    public RestErrorMessage(String context, Exception e) {
        this(context, e.getLocalizedMessage(), e.getClass().getCanonicalName());
    }

    @Nullable
    public static RestErrorMessage valueOf(@Nullable Object value) {
        if (value instanceof RestErrorMessage) {
            return (RestErrorMessage)value;
        }
        if (value instanceof Map) {
            return new RestErrorMessage((Map)value);
        }
        return null;
    }

    @Nullable
    public String getContext() {
        return this.getStringProperty(CONTEXT);
    }

    @Nullable
    public String getExceptionName() {
        return this.getStringProperty(EXCEPTION_NAME);
    }

    @Nullable
    public String getMessage() {
        return this.getStringProperty(MESSAGE);
    }
}

