/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api;

import com.atlassian.bitbucket.rest.v2.api.ResourceException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

public class BadRequestException
extends ResourceException {
    private static final long serialVersionUID = 1L;

    public BadRequestException(String message) {
        this(null, message);
    }

    public BadRequestException(@Nullable String context, @Nullable String message) {
        super(ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)new RestErrors(context, message)));
    }

    public BadRequestException(@Nonnull Iterable<String> messages) {
        super(ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)BadRequestException.asRestErrors(Objects.requireNonNull(messages, "messages"))));
    }

    private static RestErrors asRestErrors(Iterable<String> messages) {
        RestErrors.Builder errors = new RestErrors.Builder();
        for (String message : messages) {
            errors.add(new RestErrorMessage(message));
        }
        return errors.build();
    }
}

