/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.repository;

import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.repository.RestMinimalRef;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonSerialize
@JsonSurrogate(value=Ref.class)
public class RestRef
extends RestMinimalRef {
    private static final String LATEST_CHANGESET = "latestChangeset";
    private static final String LATEST_COMMIT = "latestCommit";

    public RestRef() {
    }

    public RestRef(Ref ref) {
        this(ref.getId(), ref.getDisplayId(), ref.getType(), ref.getLatestCommit());
    }

    protected RestRef(String id, String displayId, RefType type, String latestCommit) {
        super(id, displayId, type);
        this.put(LATEST_COMMIT, latestCommit);
        this.put(LATEST_CHANGESET, latestCommit);
    }

    @Schema(example="8d51122def5632836d1cb1026e879069e10a1e13", accessMode=Schema.AccessMode.READ_ONLY)
    public String getLatestChangeset() {
        return this.getStringProperty(LATEST_CHANGESET);
    }

    @Schema(example="8d51122def5632836d1cb1026e879069e10a1e13", accessMode=Schema.AccessMode.READ_ONLY)
    public String getLatestCommit() {
        return this.getStringProperty(LATEST_COMMIT);
    }
}

