/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.commit;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.commit.RestMinimalCommit;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.user.RestPerson;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sun.jersey.spi.container.ContainerRequest;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Commit.class)
public class RestCommit
extends RestMinimalCommit {
    public static final Function<Commit, RestCommit> REST_TRANSFORM = RestCommit::new;
    public static final RestCommit EXAMPLE = new RestCommit("abcdef0123abcdef4567abcdef8987abcdef6543", "abcdef0123a", RestPerson.EXAMPLE, new Date(), "WIP on feature 1", Lists.newArrayList((Object[])new RestMinimalCommit[]{RestMinimalCommit.EXAMPLE}), null);
    public static final RestCommit EXAMPLE_ALT = new RestCommit("def0123abcdef4567abcdef8987abcdef6543abc", "def0123abcd", RestPerson.EXAMPLE, new Date(), "More work on feature 1", Lists.newArrayList((Object[])new RestMinimalCommit[]{RestMinimalCommit.EXAMPLE}), null);
    public static final RestPage<RestCommit> PAGE_EXAMPLE = RestDocUtils.decorate(RestDocUtils.pageOf(EXAMPLE_ALT), ImmutableMap.of((Object)"authorCount", (Object)1, (Object)"totalCount", (Object)1));

    public RestCommit(Commit commit) {
        this(commit.getId(), commit.getDisplayId(), RestPerson.REST_TRANSFORM.apply(commit.getAuthor()), commit.getAuthorTimestamp(), commit.getMessage(), (Collection<RestMinimalCommit>)ImmutableList.copyOf((Collection)RestMapEntity.transform((Iterable)commit.getParents(), RestMinimalCommit.REST_TRANSFORM)), (Map<String, Object>)commit.getProperties());
    }

    private RestCommit(String id, String displayId, RestPerson author, Date authorTimestamp, String message, Collection<RestMinimalCommit> parents, Map<String, Object> properties) {
        super(id, displayId);
        this.putIfNotNull("author", author);
        this.put("authorTimestamp", authorTimestamp);
        this.put("message", message);
        this.put("parents", parents);
        this.putIfNotEmpty("properties", properties);
    }

    public static Function<Commit, RestCommit> createTransformer(@Nonnull ContainerRequest request, final @Nonnull AvatarEnricher avatarEnricher) {
        final AvatarRequest avatarRequest = RestUtils.makeAvatarRequest((ContainerRequest)request);
        if (avatarRequest == null) {
            return REST_TRANSFORM;
        }
        return new Function<Commit, RestCommit>(){

            @Override
            public RestCommit apply(Commit commit) {
                RestCommit restCommit = new RestCommit(commit);
                avatarEnricher.enrich((Object)restCommit, avatarRequest);
                return restCommit;
            }
        };
    }
}

