/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.user.ExampleDetailedUser;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.user.RestPerson;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Function;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=PullRequestParticipant.class)
public class RestPullRequestParticipant
extends RestMapEntity {
    public static final Function<PullRequestParticipant, RestPullRequestParticipant> REST_TRANSFORM = new Function<PullRequestParticipant, RestPullRequestParticipant>(){

        public RestPullRequestParticipant apply(PullRequestParticipant participant) {
            return new RestPullRequestParticipant(participant);
        }
    };
    public static final String USER = "user";
    public static final String ROLE = "role";
    public static final String APPROVED = "approved";
    public static final RestPullRequestParticipant REQUEST_EXAMPLE_ADD_REVIEWER = new RestPullRequestParticipant(RestApplicationUser.EXAMPLE_NAME_ONLY, PullRequestRole.REVIEWER, null);
    public static final RestPullRequestParticipant EXAMPLE_RESPONSE_REVIEWER_APPROVED = new RestPullRequestParticipant(RestApplicationUser.RESPONSE_EXAMPLE, PullRequestRole.REVIEWER, true);
    public static final RestPullRequestParticipant EXAMPLE_RESPONSE_REVIEWER_UNAPPROVED = new RestPullRequestParticipant(RestApplicationUser.RESPONSE_EXAMPLE, PullRequestRole.REVIEWER, false);
    public static final RestPullRequestParticipant REQUEST_EXAMPLE_USER_ONLY = new RestPullRequestParticipant(RestApplicationUser.EXAMPLE_NAME_ONLY, null, null);
    public static final RestPullRequestParticipant REQUEST_EXAMPLE_REVIEWER = new RestPullRequestParticipant(RestApplicationUser.EXAMPLE_NAME_ONLY, PullRequestRole.REVIEWER, null);
    public static final RestPage<RestPullRequestParticipant> PAGE = RestDocUtils.pageOf(EXAMPLE_RESPONSE_REVIEWER_APPROVED);

    public RestPullRequestParticipant() {
    }

    public RestPullRequestParticipant(PullRequestParticipant participant) {
        this(new RestApplicationUser(participant.getUser()), participant.getRole(), participant.isApproved());
    }

    public RestPullRequestParticipant(Map<String, Object> values) {
        super(values);
    }

    private RestPullRequestParticipant(RestPerson user, PullRequestRole role, Boolean approved) {
        this.putIfNotNull(USER, user);
        this.putIfNotNull(ROLE, role);
        this.putIfNotNull(APPROVED, approved);
    }

    public PullRequestRole getRole() {
        return (PullRequestRole)this.getEnumProperty(ROLE, PullRequestRole.class);
    }

    public RestApplicationUser getUser() {
        return RestApplicationUser.valueOf(this.get(USER));
    }

    public static RestPullRequestParticipant valueOf(Object value) {
        if (value instanceof RestPullRequestParticipant) {
            return (RestPullRequestParticipant)((Object)value);
        }
        if (value instanceof Map) {
            return new RestPullRequestParticipant((Map)value);
        }
        return null;
    }

    public static RestPullRequestParticipant newExample(String name, PullRequestRole role, Boolean approved) {
        ExampleDetailedUser exampleUser = ExampleDetailedUser.newExample(name);
        return new RestPullRequestParticipant(new RestApplicationUser((ApplicationUser)exampleUser), role, approved);
    }
}

