/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.rest;

import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.stash.internal.repository.sync.rest.RestRejectedRef;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=RefSyncStatus.class)
public class RestRefSyncStatus
extends RestMapEntity {
    public static final String ENABLED = "enabled";
    private static final String AHEAD_REFS = "aheadRefs";
    private static final String AVAILABLE = "available";
    private static final String DIVERGED_REFS = "divergedRefs";
    private static final String LAST_SYNC = "lastSync";
    private static final String ORPHANED_REFS = "orphanedRefs";
    public static final RestRefSyncStatus REQUEST_EXAMPLE = new RestRefSyncStatus(){
        {
            this.put(RestRefSyncStatus.ENABLED, true);
        }
    };
    public static final RestRefSyncStatus RESPONSE_EXAMPLE = new RestRefSyncStatus(){
        {
            this.put(RestRefSyncStatus.AVAILABLE, true);
            this.put(RestRefSyncStatus.ENABLED, true);
            this.put(RestRefSyncStatus.LAST_SYNC, 1331038800000L);
            this.put(RestRefSyncStatus.AHEAD_REFS, Collections.emptySet());
            this.put(RestRefSyncStatus.DIVERGED_REFS, Collections.singleton(RestRejectedRef.DIVERGED_EXAMPLE));
            this.put(RestRefSyncStatus.ORPHANED_REFS, Collections.emptySet());
        }
    };

    public RestRefSyncStatus() {
    }

    public RestRefSyncStatus(boolean available) {
        this.put(AVAILABLE, available);
        this.put(ENABLED, false);
    }

    public RestRefSyncStatus(RefSyncStatus status) {
        this.put(AVAILABLE, status.isAvailable());
        this.put(ENABLED, status.isEnabled());
        this.put(LAST_SYNC, status.getLastSync());
        if (status.isEnabled()) {
            this.putRefs(AHEAD_REFS, status.getAheadRefs());
            this.putRefs(DIVERGED_REFS, status.getDivergedRefs());
            this.putRefs(ORPHANED_REFS, status.getOrphanedRefs());
        }
    }

    public boolean isEnabled() {
        return this.getBoolProperty(ENABLED, true);
    }

    private void putRefs(String key, Set<RejectedRef> refs) {
        this.put(key, ImmutableList.copyOf((Collection)Collections2.transform(refs, RestRejectedRef.REST_TRANSFORM)));
    }
}

