/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.sync.RejectedRefState;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.SimpleCommand;
import com.atlassian.bitbucket.scm.git.GitAgent;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import com.atlassian.bitbucket.scm.git.command.revlist.GitRevListBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.repository.sync.RefSyncConfig;
import com.atlassian.stash.internal.repository.sync.RefSyncResult;
import com.atlassian.stash.internal.repository.sync.SimpleRejectedRef;
import com.atlassian.stash.internal.repository.sync.StateRevListCommandOutputHandler;
import com.atlassian.stash.internal.repository.sync.command.AbstractCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.AbstractRefsCommandParameters;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSynchronizeRefsCommand<T extends AbstractRefsCommandParameters>
extends SimpleCommand<RefSyncResult> {
    protected final GitAgent agent;
    protected final String authorEmail;
    protected final String authorName;
    protected final RefSyncConfig config;
    protected final T parameters;
    private final GitCommandBuilderFactory builderFactory;
    private final RefSyncResult.Builder resultBuilder;

    protected AbstractSynchronizeRefsCommand(GitAgent agent, GitCommandBuilderFactory builderFactory, RefSyncConfig config, T parameters) {
        this.agent = agent;
        this.builderFactory = builderFactory;
        this.config = config;
        this.parameters = parameters;
        this.resultBuilder = new RefSyncResult.Builder();
        ApplicationUser user = ((AbstractCommandParameters)parameters).getUser();
        this.authorName = (String)StringUtils.defaultIfBlank((CharSequence)user.getDisplayName(), (CharSequence)Product.NAME);
        this.authorEmail = (String)StringUtils.defaultIfBlank((CharSequence)user.getEmailAddress(), (CharSequence)(Product.NAME.toLowerCase(Locale.US) + "@atlassian.com"));
    }

    @Nonnull
    public RefSyncResult call() {
        if (this.synchronize()) {
            this.resultBuilder.isSynchronized();
        }
        return this.resultBuilder.build();
    }

    protected void addChangedRef(@Nonnull RefChange change) {
        this.resultBuilder.changedRef(change);
    }

    protected void addRejectedRef(@Nonnull String refId, @Nonnull RejectedRefState state) {
        boolean isTag = SimpleRejectedRef.isTag(refId);
        this.resultBuilder.rejectedRef(((SimpleRejectedRef.Builder)((SimpleRejectedRef.Builder)new SimpleRejectedRef.Builder().displayId(isTag ? GitRefPattern.TAGS.unqualify(refId) : GitRefPattern.HEADS.unqualify(refId))).id(refId)).type((RefType)(isTag ? StandardRefType.TAG : StandardRefType.BRANCH)).state(state).build());
    }

    @Nonnull
    protected GitScmCommandBuilder builder() {
        return this.builderFactory.builder(((AbstractCommandParameters)this.parameters).getRepository());
    }

    @Nullable
    protected RejectedRefState calculateState(@Nonnull String refId, @Nonnull String local) {
        Branch upstream = this.agent.resolveBranch(((AbstractCommandParameters)this.parameters).getUpstream(), refId, true);
        if (upstream == null) {
            return RejectedRefState.ORPHANED;
        }
        if (StringUtils.equals((CharSequence)local, (CharSequence)upstream.getLatestCommit())) {
            return null;
        }
        return (RejectedRefState)((Object)((GitRevListBuilder)this.builder().revList().count(true).leftRight(true).rev(local + "..." + upstream.getLatestCommit()).withEnvironment("GIT_ALTERNATE_OBJECT_DIRECTORIES", this.config.getRelativePath(((AbstractCommandParameters)this.parameters).getUpstream(), ((AbstractCommandParameters)this.parameters).getRepository()))).build((CommandOutputHandler)new StateRevListCommandOutputHandler()).call());
    }

    protected abstract boolean synchronize();
}

