/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.stash.internal.plugin.PluginUpgradeHelper;
import com.atlassian.stash.internal.plugin.event.PluginInstallRequestedEvent;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StashPluginManager
extends DefaultPluginManager {
    private static final Set<String> PLUGINS_DISABLED_FOR_DEFAULT = ImmutableSet.builder().add((Object)"com.atlassian.bitbucket.server.bitbucket-mirroring-mirror").build();
    private static final Set<String> PLUGINS_DISABLED_FOR_MIRROR = ImmutableSet.builder().add((Object[])new String[]{"com.atlassian.bitbucket.server.bitbucket-branch", "com.atlassian.bitbucket.server.bitbucket-cluster-info", "com.atlassian.bitbucket.server.bitbucket-comment-likes", "com.atlassian.bitbucket.server.bitbucket-comment-properties", "com.atlassian.bitbucket.server.bitbucket-compare", "com.atlassian.bitbucket.server.bitbucket-crowd-sso", "com.atlassian.bitbucket.server.bitbucket-highlight", "com.atlassian.bitbucket.server.bitbucket-inbox", "com.atlassian.bitbucket.server.bitbucket-jira", "com.atlassian.bitbucket.server.bitbucket-jira-development-integration", "com.atlassian.bitbucket.server.bitbucket-markup-renderers", "com.atlassian.bitbucket.server.bitbucket-mirroring-upstream", "com.atlassian.bitbucket.server.bitbucket-pull-request-branch-deletion", "com.atlassian.bitbucket.server.bitbucket-pull-request-properties", "com.atlassian.bitbucket.server.bitbucket-readme", "com.atlassian.bitbucket.server.bitbucket-ref-restriction", "com.atlassian.bitbucket.server.bitbucket-repository-ref-sync", "com.atlassian.bitbucket.server.bitbucket-sourcetree-plugin", "com.atlassian.bitbucket.server.bitbucket-stp", "com.atlassian.bitbucket.server.bitbucket-tag", "com.atlassian.integration.jira.jira-integration-plugin", "com.atlassian.plugins.atlassian-chaperone", "com.atlassian.plugins.atlassian-remote-event-common-plugin", "com.atlassian.plugins.atlassian-remote-event-consumer-plugin", "com.atlassian.plugins.atlassian-remote-event-producer-plugin", "com.atlassian.plugins.atlassian-nps-plugin", "com.atlassian.plugins.base-hipchat-integration-plugin", "com.atlassian.plugins.base-hipchat-integration-plugin-api", "com.atlassian.plugins.issue-status-plugin", "com.atlassian.stash.plugins.stash-hipchat-integration-plugin", "com.atlassian.stash.plugins.stash-remote-event-bitbucket-server-spi"}).build();
    private final PluginEventManager eventManager;
    private final ApplicationMode mode;
    private final PluginUpgradeHelper upgradeHelper;
    private volatile boolean starting;

    public StashPluginManager(PluginPersistentStateStore store, List<PluginLoader> pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager eventManager, PluginUpgradeHelper upgradeHelper, ApplicationMode mode) {
        super(store, pluginLoaders, moduleDescriptorFactory, eventManager);
        this.eventManager = eventManager;
        this.mode = mode;
        this.upgradeHelper = upgradeHelper;
    }

    public void earlyStartup() throws PluginParseException, NotificationException {
        this.starting = true;
        try {
            this.upgradeHelper.withUpgrade(() -> super.earlyStartup());
        }
        finally {
            this.starting = false;
        }
    }

    protected void addPlugins(PluginLoader loader, Collection<Plugin> pluginsToInstall) throws PluginParseException {
        if (this.starting) {
            Set<String> disabledPlugins = this.mode == ApplicationMode.MIRROR ? PLUGINS_DISABLED_FOR_MIRROR : PLUGINS_DISABLED_FOR_DEFAULT;
            Iterator<Plugin> iter = pluginsToInstall.iterator();
            while (iter.hasNext()) {
                Plugin plugin = iter.next();
                if (!disabledPlugins.contains(plugin.getKey())) continue;
                iter.remove();
            }
            this.eventManager.broadcast((Object)new PluginInstallRequestedEvent((Object)this, pluginsToInstall.size()));
        }
        super.addPlugins(loader, pluginsToInstall);
    }

    protected PluginPersistentState getState() {
        return this.upgradeHelper.wrap(super.getState());
    }
}

