/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.Application;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.main.PluginsConfigurationBuilder;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.stash.internal.ApplicationSettings;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class PluginConfigurationFactory {
    public static final String KEY_STASH_PLUGINS_LIST = "stash.plugins.list";
    private static final Logger LOG = LoggerFactory.getLogger(PluginConfigurationFactory.class);

    public static PluginsConfiguration create(ApplicationSettings applicationSettings, Application hostApplication, HostComponentProvider hostComponentProvider, ModuleDescriptorFactory moduleDescriptorFactory, PackageScannerConfiguration packageScannerConfiguration, PluginPersistentStateStore pluginPersistentStateStore, String bundledPlugins, ServletContext servletContext) throws IOException {
        File frameworkBundlesDir = new File(servletContext.getRealPath("/WEB-INF/osgi-framework-bundles"));
        LOG.debug("Using OSGi framework bundles from: {}", (Object)frameworkBundlesDir);
        return new PluginsConfigurationBuilder().useLegacyDynamicPluginDeployer(true).bundledPluginUrl(PluginConfigurationFactory.getBundledPluginsUrl(bundledPlugins)).bundledPluginCacheDirectory(applicationSettings.getBundledPluginsDir()).pluginDirectory(applicationSettings.getInstalledPluginsDir()).moduleDescriptorFactory(moduleDescriptorFactory).packageScannerConfiguration(packageScannerConfiguration).hostComponentProvider(hostComponentProvider).osgiPersistentCache(applicationSettings.getOsgiCacheDir()).pluginStateStore(pluginPersistentStateStore).application(hostApplication).frameworkBundleDirectory(frameworkBundlesDir).build();
    }

    private static URL getBundledPluginsUrl(String bundledPlugins) throws IOException {
        String list = System.getProperty(KEY_STASH_PLUGINS_LIST);
        if (StringUtils.isNotBlank((CharSequence)list)) {
            try {
                return URI.create(list).toURL();
            }
            catch (MalformedURLException e) {
                LOG.warn("stash.plugins.list does not define a valid URL [" + list + "]", (Throwable)e);
            }
        }
        return new ClassPathResource(bundledPlugins).getURL();
    }
}

