/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.logback.pattern;

import ch.qos.logback.classic.pattern.PublicExtendedThrowableProxyConverter;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.atlassian.stash.internal.logback.pattern.FilteredThrowableProxy;
import java.sql.SQLException;
import java.util.Iterator;

public class EnhancedThrowableConverter
extends PublicExtendedThrowableProxyConverter {
    private static final String PROP_FULL_STACK_TRACES = "bitbucket.log.fullStackTraces";
    private final boolean logFullStackTrace = Boolean.getBoolean("bitbucket.log.fullStackTraces");

    protected String throwableProxyToString(IThrowableProxy tp) {
        IThrowableProxy currentThrowable;
        StringBuilder buf = new StringBuilder(32);
        Object object = currentThrowable = this.logFullStackTrace ? tp : new FilteredThrowableProxy(tp);
        while (currentThrowable != null) {
            SQLException sqlException = this.extractChainedSQLException(currentThrowable);
            if (sqlException != null) {
                this.subjoinSqlException(buf, sqlException);
            } else {
                this.subjoinThrowableProxy(buf, currentThrowable);
            }
            currentThrowable = currentThrowable.getCause();
        }
        return buf.toString();
    }

    void subjoinSqlException(StringBuilder buf, SQLException sqlException) {
        Iterator<Throwable> iterator = sqlException.iterator();
        while (iterator.hasNext()) {
            Throwable chainedException = iterator.next();
            ThrowableProxy tp = new ThrowableProxy(chainedException);
            this.subjoinThrowableProxy(buf, (IThrowableProxy)tp);
            if (!iterator.hasNext()) continue;
            buf.append("Next Exception: ");
        }
    }

    private SQLException extractChainedSQLException(IThrowableProxy tp) {
        SQLException sqlException;
        Throwable t = this.unwrapException(tp);
        if (t instanceof SQLException && (sqlException = (SQLException)t).getNextException() != null) {
            return sqlException;
        }
        return null;
    }

    private Throwable unwrapException(IThrowableProxy tp) {
        if (tp instanceof FilteredThrowableProxy) {
            return this.unwrapException(((FilteredThrowableProxy)tp).getThrowableProxy());
        }
        if (tp instanceof ThrowableProxy) {
            return ((ThrowableProxy)tp).getThrowable();
        }
        this.addWarn(String.format("Unexpected implementation of %s: %s", IThrowableProxy.class.getSimpleName(), tp.getClass().getName()));
        return null;
    }
}

