/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.util.ReflectionUtils;

public class TransactionAwareEventPublisher
implements EventPublisher {
    private static final Map<Class, TransactionAware.When> TRANSACTION_AWARE_OVERRIDES = ImmutableMap.builder().put(DirectoryUpdatedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(GroupDeletedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(GroupMembershipCreatedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(GroupMembershipDeletedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(UserDeletedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(UserUpdatedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).build();
    private static final Logger log = LoggerFactory.getLogger(TransactionAwareEventPublisher.class);
    private final AuthenticationContext authenticationContext;
    private final EventPublisher delegate;
    private final TransactionSynchronizer synchronizer;
    private final Field userField;

    public TransactionAwareEventPublisher(AuthenticationContext authenticationContext, EventPublisher delegate, TransactionSynchronizer synchronizer) {
        this.authenticationContext = authenticationContext;
        this.delegate = delegate;
        this.synchronizer = synchronizer;
        this.userField = TransactionAwareEventPublisher.getField("user");
    }

    public void publish(@Nonnull Object event) {
        this.setFields(Preconditions.checkNotNull((Object)event, (Object)"event"));
        TransactionAware.When publishWhen = TransactionAwareEventPublisher.getTransactionConfiguration(event.getClass());
        if (publishWhen != null && publishWhen != TransactionAware.When.IMMEDIATE && this.synchronizer.register(this.createPublisher(publishWhen, event))) {
            log.debug("Deferring publishing for {} until {}", (Object)event.getClass().getSimpleName(), (Object)publishWhen);
            return;
        }
        this.delegate.publish(event);
    }

    public void register(Object listener) {
        this.delegate.register(listener);
    }

    public void unregister(Object listener) {
        this.delegate.unregister(listener);
    }

    public void unregisterAll() {
        this.delegate.unregisterAll();
    }

    protected void setFields(Object event) {
        if (event instanceof ApplicationEvent && this.authenticationContext != null) {
            ReflectionUtils.setField((Field)this.userField, (Object)event, (Object)this.authenticationContext.getCurrentUser());
        }
    }

    protected static Field getField(String fieldName) {
        Field field = ReflectionUtils.findField(ApplicationEvent.class, (String)fieldName);
        ReflectionUtils.makeAccessible((Field)field);
        return field;
    }

    private TransactionSynchronization createPublisher(TransactionAware.When publishWhen, Object event) {
        switch (publishWhen) {
            case AFTER_COMMIT: {
                return new AfterCommitPublisher(event);
            }
            case AFTER_COMPLETION: {
                return new AfterCompletionPublisher(event);
            }
        }
        throw new IllegalArgumentException(publishWhen + " is not a known publishing point");
    }

    private static TransactionAware.When getTransactionConfiguration(Class eventClass) {
        TransactionAware annotation;
        TransactionAware.When publishWhen = TRANSACTION_AWARE_OVERRIDES.get(eventClass);
        if (publishWhen == null && (annotation = (TransactionAware)AnnotationUtils.findAnnotation((Class)eventClass, TransactionAware.class)) != null) {
            publishWhen = annotation.value();
        }
        return publishWhen;
    }

    private class AfterCompletionPublisher
    extends TransactionSynchronizationAdapter {
        private final Object event;

        public AfterCompletionPublisher(Object event) {
            this.event = event;
        }

        public void afterCompletion(int status) {
            log.debug("Publishing {} after completion (Status: {})", (Object)this.event.getClass().getSimpleName(), (Object)status);
            TransactionAwareEventPublisher.this.delegate.publish(this.event);
        }
    }

    private class AfterCommitPublisher
    extends TransactionSynchronizationAdapter {
        private final Object event;

        public AfterCommitPublisher(Object event) {
            this.event = event;
        }

        public void afterCompletion(int status) {
            if (status == 0) {
                log.debug("Publishing {} after commit", (Object)this.event.getClass().getSimpleName());
                TransactionAwareEventPublisher.this.delegate.publish(this.event);
            } else {
                log.trace("Discarding {}; the transaction was not committed (Status: {})", (Object)this.event.getClass().getSimpleName(), (Object)status);
            }
        }
    }
}

