/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.bitbucket.util.PropertiesUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="executorServiceConfiguration")
public class ExecutorServiceConfiguration {
    private static final int MIN_POOL_SIZE = 4;
    private final int corePoolSize;

    @Autowired
    public ExecutorServiceConfiguration(@Value(value="${executor.max.threads}") String coreThreads) {
        this.corePoolSize = Math.max(4, PropertiesUtils.parseExpression((String)coreThreads, (int)Runtime.getRuntime().availableProcessors()));
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }
}

