/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.util.FileUtils;
import com.atlassian.bitbucket.util.PropertiesUtils;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.home.DefaultHomeSubdirectoryResolver;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.atlassian.stash.internal.home.HomeSubdirectoryResolver;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationSettings {
    private static final Logger log = LoggerFactory.getLogger(ApplicationSettings.class);
    public static final String LOG_PATH = "log";
    static final String VERSION_FILE_NAME = ".version";
    public static final String STASH_HOME_BUILD_VERSION_PROPERTY = "stash.home.build.version";
    public static final String CONFIG_DIR_NAME = "config";
    public static final String DATA_DIR_NAME = "data";
    public static final String PLUGINS_DIR_NAME = "plugins";
    public static final String INSTALLED_PLUGINS_DIR_NAME = "installed-plugins";
    public static final String REPOSITORIES_DIR_NAME = "repositories";
    private final HomeSubdirectoryResolver homeSubdirectoryResolver;
    private final File binDir;
    private final File bundledPluginsDir;
    private final File cacheDir;
    private final File configDir;
    private final File dataDir;
    private final File exportDir;
    private final File homeDir;
    private final File installedPluginsDir;
    private final File libDir;
    private final File logDir;
    private final File nativeDir;
    private final File pluginsDir;
    private final File osgiCacheDir;
    private final Set<String> requiredPluginKeys;
    private final File reposDir;
    private final File sharedHomeDir;
    private final File sharedPluginsDir;
    private final File tempDir;

    public ApplicationSettings(HomeDirectoryDetails homeDirectoryDetails, Properties requiredPluginProperties, Properties versionProperties, String currentBuildVersion) {
        this(homeDirectoryDetails, new DefaultHomeSubdirectoryResolver(), requiredPluginProperties, versionProperties, currentBuildVersion);
    }

    public ApplicationSettings(HomeDirectoryDetails homeDirectoryDetails, HomeSubdirectoryResolver homeSubdirectoryResolver, Properties requiredPluginProperties, Properties versionProperties, String currentBuildVersion) {
        this.homeDir = homeDirectoryDetails.getHome();
        this.sharedHomeDir = homeDirectoryDetails.getSharedHome();
        this.homeSubdirectoryResolver = homeSubdirectoryResolver;
        log.debug("Running with Home Directory = {}, Shared Home Directory = {}", (Object)this.homeDir, (Object)this.sharedHomeDir);
        this.binDir = this.getHomeSubdirectory(this.homeDir, "bin");
        this.cacheDir = this.getHomeSubdirectory(this.homeDir, "caches");
        this.exportDir = this.getHomeSubdirectory(this.homeDir, "export");
        this.libDir = this.getHomeSubdirectory(this.homeDir, "lib");
        this.nativeDir = this.getHomeSubdirectory(this.libDir, "native");
        this.logDir = this.getHomeSubdirectory(this.homeDir, LOG_PATH);
        this.pluginsDir = this.getHomeSubdirectory(this.homeDir, PLUGINS_DIR_NAME);
        this.osgiCacheDir = FileUtils.mkdir((File)this.pluginsDir, (String)".osgi-cache");
        this.bundledPluginsDir = FileUtils.mkdir((File)this.pluginsDir, (String)".bundled-plugins");
        this.configDir = this.getHomeSubdirectory(this.sharedHomeDir, CONFIG_DIR_NAME);
        this.dataDir = this.getHomeSubdirectory(this.sharedHomeDir, DATA_DIR_NAME);
        this.reposDir = FileUtils.mkdir((File)this.dataDir, (String)REPOSITORIES_DIR_NAME);
        this.sharedPluginsDir = FileUtils.mkdir((File)this.sharedHomeDir, (String)PLUGINS_DIR_NAME);
        this.installedPluginsDir = FileUtils.mkdir((File)this.sharedPluginsDir, (String)INSTALLED_PLUGINS_DIR_NAME);
        this.tempDir = this.getHomeSubdirectory(this.homeDir, "tmp");
        ImmutableSet.Builder requiredPluginsBuilder = ImmutableSet.builder();
        if (requiredPluginProperties != null) {
            requiredPluginsBuilder.addAll((Iterable)Collections2.transform(requiredPluginProperties.keySet(), (Function)Functions.toStringFunction()));
        }
        this.requiredPluginKeys = requiredPluginsBuilder.build();
        this.updateHomeDirectoryVersions(versionProperties, new Version(currentBuildVersion));
    }

    public File getBackupDir() {
        return this.exportDir;
    }

    public File getBinDir() {
        return this.binDir;
    }

    public File getBundledPluginsDir() {
        return this.bundledPluginsDir;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getExportDir() {
        return this.exportDir;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public File getInstalledPluginsDir() {
        return this.installedPluginsDir;
    }

    public File getLibDir() {
        return this.libDir;
    }

    public File getLogDir() {
        return this.logDir;
    }

    public File getNativeDir() {
        return this.nativeDir;
    }

    public File getOsgiCacheDir() {
        return this.osgiCacheDir;
    }

    public File getPluginsDir() {
        return this.pluginsDir;
    }

    public File getSharedHomeDir() {
        return this.sharedHomeDir;
    }

    public File getSharedPluginsDir() {
        return this.sharedPluginsDir;
    }

    public File getRepositoriesDir() {
        return this.reposDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public Set<String> getRequiredPluginKeys() {
        return this.requiredPluginKeys;
    }

    private File getHomeSubdirectory(File parent, String name) {
        return this.homeSubdirectoryResolver.getHomeSubdirectory(parent, name);
    }

    private void updateHomeDirectoryVersions(Properties versionProperties, Version sourceBuild) {
        Version homeBuild = null;
        if (versionProperties != null) {
            String homeBuildString = versionProperties.getProperty(STASH_HOME_BUILD_VERSION_PROPERTY);
            if (StringUtils.isNotEmpty((CharSequence)homeBuildString)) {
                homeBuild = new Version(homeBuildString);
                if (homeBuild.compareTo(sourceBuild) > 0) {
                    log.warn("The configured home directory {} is at a higher build version {} than the {} code build version {}", new Object[]{this.getHomeDir(), homeBuild, Product.NAME, sourceBuild});
                    return;
                }
                if (homeBuild.compareTo(sourceBuild) < 0) {
                    log.info("Updated home version from {} to {}", (Object)homeBuild, (Object)sourceBuild);
                    this.writeHomeDirectoryVersion(versionProperties, sourceBuild);
                }
            }
        } else {
            versionProperties = new Properties();
        }
        if (homeBuild == null) {
            log.info("Capturing benchmark home version {}", (Object)sourceBuild);
            this.writeHomeDirectoryVersion(versionProperties, sourceBuild);
        }
    }

    private void writeHomeDirectoryVersion(Properties versionProperties, Version sourceBuild) {
        File versionFile = new File(this.getHomeDir(), VERSION_FILE_NAME);
        versionProperties.setProperty(STASH_HOME_BUILD_VERSION_PROPERTY, sourceBuild.toString());
        try {
            PropertiesUtils.writeToFile((Properties)versionProperties, (File)versionFile);
        }
        catch (IOException e) {
            log.warn("Failed to write home directory version", (Throwable)e);
        }
    }
}

