/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mesh;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import com.atlassian.webdriver.bitbucket.page.admin.mesh.AsyncProjectSelector;
import com.atlassian.webdriver.bitbucket.page.admin.mesh.MigrationStatusSelector;
import com.atlassian.webdriver.bitbucket.page.admin.mesh.RepositoryRow;
import java.util.List;
import org.openqa.selenium.By;

public class MeshMigrationPage
extends BitbucketAdminPage {
    @ElementBy(id="migration-search-filter")
    private PageElement repoNameSearchFilter;
    @ElementBy(id="repository-migration-container")
    private PageElement container;
    @ElementBy(id="search-filter")
    private PageElement searchBox;
    @ElementBy(className="migration-select-filter")
    private PageElement projectFilter;
    @ElementBy(className="migration-status-select-filter")
    private PageElement statusFilter;

    public MeshMigrationPage() {
    }

    public MeshMigrationPage(String webSudoPassword) {
        super(webSudoPassword);
    }

    public String getUrl() {
        return "/admin/git/mesh/migrations";
    }

    public MeshMigrationPage enterTextInSearchBox(String text) {
        this.searchBox.type(new CharSequence[]{text});
        return this;
    }

    public MeshMigrationPage clearTextInSearchBox() {
        this.searchBox.clear();
        return this;
    }

    public TimedQuery<List<RepositoryRow>> getRepositories() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)this.container.findAll(By.cssSelector((String)"table > tbody > tr")).stream().map(RepositoryRow::new).collect(MoreCollectors.toImmutableList()));
    }

    public AsyncProjectSelector getProjectSelector() {
        return (AsyncProjectSelector)this.pageBinder.bind(AsyncProjectSelector.class, new Object[]{this.projectFilter});
    }

    public MigrationStatusSelector getMigrationStatusSelector() {
        return (MigrationStatusSelector)this.pageBinder.bind(MigrationStatusSelector.class, new Object[]{this.statusFilter});
    }
}

