/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.permissions;

import com.atlassian.bitbucket.pageobjects.element.permissions.PermissionSelector;
import com.atlassian.bitbucket.pageobjects.element.permissions.UserOrGroupSelector;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class AddOrEditPermissionDialog
extends AbstractElementPageObject {
    public AddOrEditPermissionDialog(@Nonnull PageElement container) {
        super(container);
    }

    public void clickConfirm() {
        this.container.find(By.cssSelector((String)"[data-testid='permission-modal-confirm-button']")).click();
        Poller.waitUntilFalse((TimedQuery)this.container.timed().isPresent());
    }

    public TimedQuery<String> getSelectedPermission() {
        return this.getPermissionSelector().getSelectedPermission();
    }

    public TimedCondition isUserOrGroupEditable() {
        return this.getUserOrGroupSelector().isPresent();
    }

    public AddOrEditPermissionDialog selectPermission(String permissionString) {
        this.getPermissionSelector().selectPermission(permissionString);
        return this;
    }

    public AddOrEditPermissionDialog selectUsersOrGroups(Set<String> usersOrGroups) {
        usersOrGroups.forEach(this.getUserOrGroupSelector()::selectUserOrGroup);
        return this;
    }

    private PermissionSelector getPermissionSelector() {
        return (PermissionSelector)this.pageBinder.bind(PermissionSelector.class, new Object[]{this.container});
    }

    private UserOrGroupSelector getUserOrGroupSelector() {
        return (UserOrGroupSelector)this.pageBinder.bind(UserOrGroupSelector.class, new Object[]{this.container});
    }
}

