/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.webhook;

import com.atlassian.bitbucket.pageobjects.element.ReactSelect;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.webhook.BaseWebhookCreatePage;
import com.atlassian.webdriver.bitbucket.page.webhook.RepositoryWebhookCreateResult;
import com.atlassian.webdriver.bitbucket.page.webhook.RepositoryWebhookPage;

public class RepositoryWebhookCreatePage
extends BaseWebhookCreatePage {
    private final String projectKey;
    private final String repoSlug;

    public RepositoryWebhookCreatePage(String projectKey, String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public String getUrl() {
        return String.format("/plugins/servlet/webhooks/projects/%s/repos/%s/create", this.projectKey, this.repoSlug);
    }

    public RepositoryWebhookPage clickCancel() {
        this.cancelLink.click();
        return (RepositoryWebhookPage)this.pageBinder.bind(RepositoryWebhookPage.class, new Object[]{this.projectKey, this.repoSlug});
    }

    public RepositoryWebhookCreateResult clickConfirm() {
        this.confirmButton.click();
        return (RepositoryWebhookCreateResult)this.pageBinder.bind(RepositoryWebhookCreateResult.class, new Object[]{this.projectKey, this.repoSlug});
    }

    public RepositoryWebhookCreatePage setAuthenticationMethod(String authenticationMethod) {
        ReactSelect keySelect = (ReactSelect)this.pageBinder.bind(ReactSelect.class, new Object[]{this.container, "authentication-select"});
        keySelect.selectOptionByPartialName(authenticationMethod);
        return this;
    }

    public RepositoryWebhookCreatePage setName(String name) {
        Poller.waitUntilTrue((TimedQuery)this.nameInput.timed().isVisible());
        this.nameInput.clear().type(new CharSequence[]{name});
        return this;
    }

    public RepositoryWebhookCreatePage setPassword(String password) {
        Poller.waitUntilTrue((TimedQuery)this.passwordInput.timed().isVisible());
        this.passwordInput.clear().type(new CharSequence[]{password});
        return this;
    }

    public RepositoryWebhookCreatePage setSecret(String name) {
        Poller.waitUntilTrue((TimedQuery)this.secretInput.timed().isVisible());
        this.secretInput.clear().type(new CharSequence[]{name});
        return this;
    }

    public RepositoryWebhookCreatePage setUrl(String url) {
        Poller.waitUntilTrue((TimedQuery)this.urlInput.timed().isVisible());
        this.urlInput.clear().type(new CharSequence[]{url});
        return this;
    }

    public RepositoryWebhookCreatePage setUsername(String username) {
        Poller.waitUntilTrue((TimedQuery)this.usernameInput.timed().isVisible());
        this.usernameInput.clear().type(new CharSequence[]{username});
        return this;
    }
}

