/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.setup;

import com.atlassian.pageobjects.binder.PageBindingWaitException;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.setup.SetupTrackingPage;
import org.openqa.selenium.By;

public abstract class SetupPage
extends BitbucketPage
implements SetupTrackingPage {
    @ElementBy(id="setup-progress-iframe")
    private PageElement setupProgressTrackingIframe;

    @WaitUntil
    public void ensureHeadingMatches() {
        SetupPage.isOnSetupStep(this, this.elementFinder, this.getStepHeading());
    }

    public abstract String getStepHeading();

    @Override
    public String getTrackingIframeTargetUrl() {
        return this.setupProgressTrackingIframe.getAttribute("src");
    }

    public String getUrl() {
        return "/setup";
    }

    @Override
    public boolean hasTrackingIframe() {
        return this.setupProgressTrackingIframe.isPresent();
    }

    static void isOnSetupStep(BitbucketPage page, PageElementFinder elementFinder, String title) {
        PageElement headingElement = elementFinder.find(By.cssSelector((String)".step .setup-header h2"));
        try {
            Poller.waitUntilTrue((TimedQuery)headingElement.timed().hasText(title));
        }
        catch (AssertionError e) {
            if (headingElement.isPresent() && headingElement.isVisible()) {
                throw new PageBindingWaitException(String.format("Expected heading to be %s, got %s", title, headingElement.getText().trim()), (Object)page);
            }
            throw new PageBindingWaitException("Failed to find heading on SetupPage", (Object)page);
        }
    }
}

