/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mirror;

import com.atlassian.bitbucket.hamcrest.SimpleTypeSafeMatcher;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.AbstractMirrorConfigPage;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class MirrorNodesConfigPage
extends AbstractMirrorConfigPage {
    private static final String SYNCHRONIZED_STATE = "SYNCHRONIZED";
    @ElementBy(className="mirror-nodes")
    private PageElement tableContainer;

    public MirrorNodesConfigPage(String type, String mirrorId) {
        super(type, mirrorId);
    }

    @WaitUntil
    public void ensureContentIsLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.tableContainer.timed().isVisible());
        Poller.waitUntil((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, this::getNodesRows), (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }

    public List<NodeRow> getNodesRows() {
        return (List)this.tableContainer.findAll(By.cssSelector((String)"table > tbody > tr")).stream().map(e -> e.withTimeout(TimeoutType.AJAX_ACTION)).map(e -> (NodeRow)this.pageBinder.bind(NodeRow.class, new Object[]{e})).collect(MoreCollectors.toImmutableList());
    }

    public void waitUntilAllNodesSynchronized() {
        Poller.waitUntil((String)"All nodes synchronized", (TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, this::getNodesRows, (TimeoutType)TimeoutType.SLOW_PAGE_LOAD), (Matcher)Matchers.everyItem((Matcher)new SimpleTypeSafeMatcher<NodeRow>(){

            protected boolean matchesSafely(NodeRow nodeRow) {
                return nodeRow.getStatus().equals(MirrorNodesConfigPage.SYNCHRONIZED_STATE);
            }
        }));
    }

    public static class NodeRow
    extends AbstractElementPageObject {
        public NodeRow(PageElement element) {
            super(element);
        }

        public String getStatus() {
            return this.container.find(By.xpath((String)"td[4]")).getText();
        }

        public SupportZipColumn supportZipColumn() {
            return (SupportZipColumn)this.pageBinder.bind(SupportZipColumn.class, new Object[]{this.container.find(By.xpath((String)"td[6]"))});
        }
    }

    public static class SupportZipColumn
    extends AbstractElementPageObject {
        @Inject
        private PageElementFinder elementFinder;

        public SupportZipColumn(PageElement container) {
            super(container);
        }

        public CustomizeSupportZipModal clickCreateZipButton() {
            PageElement button = this.zipButton();
            Poller.waitUntil((TimedQuery)button.timed().getText(), (Matcher)Matchers.is((Object)"Create zip"));
            button.click();
            return (CustomizeSupportZipModal)this.pageBinder.bind(CustomizeSupportZipModal.class, new Object[]{this.elementFinder.find(By.className((String)"customise-support-zip-form"))});
        }

        public String getMessage() {
            return this.container.find(By.cssSelector((String)"[data-testid='node-message']")).getText();
        }

        public TimedQuery<Boolean> isDownloadZipButtonPresent() {
            PageElement zipButton = this.zipButton();
            return Conditions.forSupplier((Timeouts)this.timeouts, () -> zipButton.getText().equals("Download zip") && zipButton.isPresent());
        }

        public TimedQuery<Boolean> isZipButtonEnabled() {
            PageElement zipButton = this.zipButton();
            return Conditions.forSupplier((Timeouts)this.timeouts, () -> {
                String disabled = zipButton.getAttribute("disabled");
                return disabled == null || "false".equals(disabled);
            });
        }

        public void waitForProgressToBeFinished() {
            PageElement progressBar = this.progressBar();
            Poller.waitUntilTrue((TimedQuery)progressBar.withTimeout(TimeoutType.PAGE_LOAD).timed().isVisible());
            Poller.waitUntil((TimedQuery)progressBar.find(By.tagName((String)"span")).withTimeout(TimeoutType.PAGE_LOAD).timed().getAttribute("style"), (Matcher)new CustomTypeSafeMatcher<String>("Progress bar is 100% complete"){

                protected boolean matchesSafely(String style) {
                    return style.contains("width: 100%");
                }
            });
        }

        private PageElement progressBar() {
            return this.find(By.cssSelector((String)"[data-testid='progress-bar']"));
        }

        private PageElement zipButton() {
            return this.find(By.cssSelector((String)"[data-testid='create-support-zip']"));
        }

        public static class CustomizeSupportZipModal
        extends AbstractElementPageObject {
            @ElementBy(cssSelector="[data-testid='cancel-btn']")
            private PageElement cancelButton;
            @ElementBy(cssSelector="[data-testid='submit']")
            private PageElement createZipButton;
            private List<PageElement> radioGroups;

            public CustomizeSupportZipModal(PageElement container) {
                super(container);
                this.radioGroups = container.findAll(By.xpath((String)"//div[@role='radiogroup']"));
            }

            public void clickCancel() {
                this.cancelButton.click();
                Poller.waitUntilFalse((TimedQuery)this.container.timed().isVisible());
            }

            public void clickCreateZip() {
                this.createZipButton.click();
                Poller.waitUntilFalse((TimedQuery)this.container.timed().isVisible());
            }

            public void clickSelectedFileType(String fileType) {
                this.getFileTypesCheckboxes().stream().filter(e -> e.getText().startsWith(fileType)).findFirst().ifPresent(PageElement::click);
            }

            @WaitUntil
            public void ensureContentIsLoaded() {
                Poller.waitUntilTrue((TimedQuery)this.container.timed().isVisible());
            }

            public RadioGroup getFileModificationOptions() {
                return (RadioGroup)this.pageBinder.bind(RadioGroup.class, new Object[]{this.radioGroups.get(0)});
            }

            public RadioGroup getFileSizeOptions() {
                return (RadioGroup)this.pageBinder.bind(RadioGroup.class, new Object[]{this.radioGroups.get(1)});
            }

            public RadioGroup getFileTypesOptions() {
                return (RadioGroup)this.pageBinder.bind(RadioGroup.class, new Object[]{this.radioGroups.get(2)});
            }

            public Set<String> getSelectedFileTypes() {
                return (Set)this.getFileTypesCheckboxes().stream().map(PageElement::getText).collect(MoreCollectors.toImmutableSet());
            }

            private List<PageElement> getFileTypesCheckboxes() {
                return this.container.findAll(By.xpath((String)"//label/input[@type='checkbox' and @aria-checked='true']/.."));
            }
        }

        public static class RadioGroup
        extends AbstractElementPageObject {
            private final List<PageElement> labels;

            public RadioGroup(PageElement container) {
                super(container);
                this.labels = container.findAll(By.tagName((String)"label"));
            }

            public void click(String option) {
                this.labels.stream().filter(e -> e.getText().equalsIgnoreCase(option)).findFirst().ifPresent(PageElement::click);
            }

            public Set<String> getAllOptions() {
                return (Set)this.labels.stream().map(PageElement::getText).collect(MoreCollectors.toImmutableSet());
            }

            public String getSelectedOption() {
                return this.labels.stream().filter(e -> e.find(By.tagName((String)"input")).hasAttribute("checked", "true")).map(PageElement::getText).findFirst().orElse(null);
            }
        }
    }
}

