/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.defaulttasks;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.admin.defaulttasks.dialog.AbstractDefaultTaskForm;
import com.atlassian.webdriver.bitbucket.page.admin.defaulttasks.taskrow.AbstractDefaultTaskRow;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public abstract class AbstractDefaultTasksPage
extends BaseSidebarPage {
    protected static final String DEFAULT_TASKS_URL_PATH = "/settings/default-tasks";
    @ElementBy(cssSelector="[data-testid='add-default-task-button']")
    private PageElement addDefaultTaskButton;
    @ElementBy(cssSelector="[data-testid='add-default-task-flag']")
    private PageElement addTaskFlag;
    @ElementBy(cssSelector="[data-testid='default-task-modal]")
    private PageElement defaultTaskDialog;
    @ElementBy(cssSelector="[data-testid='default-tasks-table']")
    private PageElement defaultTasksTable;
    @ElementBy(cssSelector="[data-testid='delete-default-task-flag']")
    private PageElement deleteTaskFlag;
    @Inject
    private PageElementFinder pageElementFinder;
    @ElementBy(cssSelector="[data-testid='update-default-task-flag']")
    private PageElement updateTaskFlag;

    public AbstractDefaultTaskForm addDefaultTask() {
        this.addDefaultTaskButton.click();
        return this.bindTaskDialog(this.defaultTaskDialog);
    }

    public DefaultTaskFlag addFlag() {
        return (DefaultTaskFlag)this.pageBinder.bind(DefaultTaskFlag.class, new Object[]{this.addTaskFlag});
    }

    public abstract AbstractDefaultTaskForm bindTaskDialog(@Nonnull PageElement var1);

    public abstract AbstractDefaultTaskRow bindTaskRow(@Nonnull PageElement var1);

    public DefaultTaskFlag deleteFlag() {
        return (DefaultTaskFlag)this.pageBinder.bind(DefaultTaskFlag.class, new Object[]{this.deleteTaskFlag});
    }

    public TimedQuery<List<AbstractDefaultTaskRow>> getDefaultTaskList() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)this.elementFinder.findAll(By.className((String)"default-task-row")).stream().map(this::bindTaskRow).collect(MoreCollectors.toImmutableList()));
    }

    public TimedQuery<AbstractDefaultTaskRow> getLatestRowContaining(String taskDescription) {
        Poller.waitUntil(this.getDefaultTaskList(), (Matcher)Matchers.notNullValue());
        return Queries.forSupplier((Timeouts)this.timeouts, () -> ((List)this.getDefaultTaskList().now()).stream().filter(row -> row.getTaskDescription().contains(taskDescription)).findFirst().orElse(null));
    }

    public DefaultTaskFlag updateFlag() {
        return (DefaultTaskFlag)this.pageBinder.bind(DefaultTaskFlag.class, new Object[]{this.updateTaskFlag});
    }

    public static class DefaultTaskFlag
    extends AbstractElementPageObject {
        public DefaultTaskFlag(@Nonnull PageElement container) {
            super(container);
        }

        public void close() {
            this.container.find(By.cssSelector((String)"[data-testid$='-default-task-flag-dismiss']")).click();
        }

        public boolean isPresent() {
            return this.container.isPresent();
        }

        public boolean isVisible() {
            return this.container.isVisible();
        }
    }
}

