/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.GlobalRepositoryTable;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;

public class ForkListPage
extends BaseRepositoryPage {
    @ElementBy(className="paged-table-filter-input")
    private PageElement filterField;
    @ElementBy(className="fork-this-repository")
    private PageElement emptyStateCreateForkLink;
    @ElementBy(cssSelector=".aui-page-header-actions .fork-repo")
    private PageElement createForkLink;
    @ElementBy(cssSelector=".filterable-repository-table .entity-table", pageElementClass=GlobalRepositoryTable.class)
    private GlobalRepositoryTable repositoryTable;
    @ElementBy(cssSelector=".paged-table-container aui-spinner")
    private PageElement tableSpinner;

    public ForkListPage(String projectKey, String repoSlug) {
        super(projectKey, repoSlug);
    }

    public String getUrl() {
        return "/projects/" + this.projectKey + "/repos/" + this.slug + "/forks";
    }

    public boolean canCreateFork() {
        return this.createForkLink.isPresent();
    }

    public boolean canCreateForkInEmptyState() {
        return this.emptyStateCreateForkLink.isPresent();
    }

    public boolean isInEmptyState() {
        return !this.repositoryTable.isPresent();
    }

    public boolean isLoading() {
        return this.tableSpinner.isPresent();
    }

    public GlobalRepositoryTable getRepositoryTable() {
        return this.repositoryTable;
    }

    public String getTableLastUpdated() {
        return this.repositoryTable.getAttribute("data-last-updated");
    }

    public ForkListPage setFilter(String filter) {
        this.filterField.clear();
        this.filterField.type(new CharSequence[]{filter});
        return this;
    }
}

