/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.dashboard.DashboardJiraIssuesSection;
import com.atlassian.webdriver.bitbucket.element.dashboard.DashboardPullRequestSection;
import com.atlassian.webdriver.bitbucket.element.dashboard.DashboardPullRequestSuggestions;
import com.atlassian.webdriver.bitbucket.element.dashboard.DashboardRepositories;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import org.openqa.selenium.By;

public class DashboardPage
extends BitbucketPage {
    public static final String URL = "/dashboard";
    @ElementBy(className="closed-pull-requests")
    private PageElement closedPullRequests;
    @ElementBy(className="created-pull-requests")
    private PageElement createdPullRequests;
    @ElementBy(className="dashboard-jira-issues")
    private PageElement jiraIssues;
    @ElementBy(className="dashboard-suggestions-list")
    private PageElement pullRequestSuggestions;
    @ElementBy(className="dashboard-repositories-section")
    private PageElement repositories;
    @ElementBy(className="reviewing-pull-requests")
    private PageElement reviewingPullRequests;
    @ElementBy(cssSelector="html")
    private PageElement rootElement;

    public void focusNextPullRequest() {
        this.useShortcut("j");
    }

    public void focusPreviousPullRequest() {
        this.useShortcut("k");
    }

    public DashboardPullRequestSection getClosedPullRequestsSection() {
        return (DashboardPullRequestSection)this.pageBinder.bind(DashboardPullRequestSection.class, new Object[]{this.closedPullRequests});
    }

    public DashboardPullRequestSection getCreatedPullRequestsSection() {
        return (DashboardPullRequestSection)this.pageBinder.bind(DashboardPullRequestSection.class, new Object[]{this.createdPullRequests});
    }

    public DashboardJiraIssuesSection getJiraIssuesSection() {
        Poller.waitUntilTrue((TimedQuery)this.jiraIssues.timed().isPresent());
        return (DashboardJiraIssuesSection)this.pageBinder.bind(DashboardJiraIssuesSection.class, new Object[]{this.jiraIssues});
    }

    public DashboardPullRequestSuggestions getPullRequestSuggestions() {
        return (DashboardPullRequestSuggestions)this.pageBinder.bind(DashboardPullRequestSuggestions.class, new Object[]{this.pullRequestSuggestions});
    }

    public DashboardRepositories getRepositories() {
        return (DashboardRepositories)this.pageBinder.bind(DashboardRepositories.class, new Object[]{this.repositories});
    }

    public DashboardPullRequestSection getReviewingPullRequestsSection() {
        return (DashboardPullRequestSection)this.pageBinder.bind(DashboardPullRequestSection.class, new Object[]{this.reviewingPullRequests});
    }

    public String getUrl() {
        return URL;
    }

    public boolean hasJiraIssuesSection() {
        return this.jiraIssues.withTimeout(TimeoutType.AJAX_ACTION).isPresent();
    }

    public Boolean isUpdating() {
        return !this.rootElement.find(By.cssSelector((String)"[data-testid=\"scheduler-global-timeout-flag\"]")).isPresent();
    }

    public void resumeUpdates() {
        this.rootElement.find(By.cssSelector((String)"[data-testid=\"scheduler-global-timeout-flag-dismiss\"]")).click();
    }
}

