/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.hamcrest.IsBlankString;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.SearchableSelectorDialog;
import java.util.Objects;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class SearchableSelector {
    @Inject
    private PageBinder pageBinder;
    @Inject
    private PageElementFinder elementFinder;
    private PageElement trigger;
    private By dialogLocator;
    private PageElement inputField;

    public SearchableSelector(PageElement trigger, By dialogLocator) {
        this(trigger, dialogLocator, null);
    }

    public SearchableSelector(PageElement trigger, By dialogLocator, PageElement inputField) {
        this.trigger = Objects.requireNonNull(trigger, "trigger");
        this.dialogLocator = Objects.requireNonNull(dialogLocator, "dialogLocator");
        this.inputField = inputField;
    }

    public SearchableSelectorDialog open() {
        SearchableSelectorDialog searchableSelectorDialog = this.getDialog();
        if (!((Boolean)searchableSelectorDialog.isOpen().now()).booleanValue()) {
            this.trigger.click();
        }
        Poller.waitUntilTrue((TimedQuery)searchableSelectorDialog.isOpen());
        Poller.waitUntilFalse((TimedQuery)searchableSelectorDialog.isLoadingPage());
        return searchableSelectorDialog;
    }

    public TimedQuery<String> getSelectedValue() {
        return this.getValueInput().timed().getValue();
    }

    public String getTriggerText() {
        return this.trigger.getText();
    }

    public String getSelectedItemName() {
        return this.trigger.find(By.className((String)"name")).getText();
    }

    public TimedCondition hasValue() {
        return Conditions.forMatcher(this.getSelectedValue(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
    }

    public SearchableSelectorDialog getDialog() {
        return (SearchableSelectorDialog)this.pageBinder.bind(SearchableSelectorDialog.class, new Object[]{this.elementFinder.find(this.dialogLocator)});
    }

    public void clearInput() {
        if (this.inputField != null && this.inputField.isVisible()) {
            this.inputField.clear();
            Poller.waitUntil((TimedQuery)this.inputField.timed().getValue(), (Matcher)IsBlankString.blank());
        }
    }

    private PageElement getValueInput() {
        Objects.requireNonNull(this.inputField, "Input field must be provided to get the value input");
        return this.inputField;
    }
}

