/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page.next;

import com.atlassian.bitbucket.pageobjects.element.next.EditFileActions;
import com.atlassian.bitbucket.pageobjects.element.next.LegacySourceFileContent;
import com.atlassian.bitbucket.pageobjects.element.next.SourceFileContent;
import com.atlassian.bitbucket.pageobjects.page.next.FileContentPage;
import com.atlassian.bitbucket.pageobjects.page.next.FileLayoutPage;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.CodeMirrorSourceFileContent;
import com.atlassian.webdriver.bitbucket.element.EditFileFooter;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class FileSourcePage
extends FileContentPage<SourceFileContent> {
    @ElementBy(cssSelector="[data-testid='blame-button']")
    private PageElement blameButton;
    @ElementBy(className="file-viewer", pageElementClass=CodeMirrorSourceFileContent.class)
    private CodeMirrorSourceFileContent codemirrorFileContent;
    @ElementBy(cssSelector="[data-testid='file-content-mode-diff']")
    private PageElement diffModeButton;
    @ElementBy(cssSelector="[data-testid='diff-options-dropdown-trigger']")
    private PageElement diffOptionsDropdownTrigger;
    @ElementBy(className="diff-text")
    private PageElement fileContentTable;
    @ElementBy(className="file-viewer", pageElementClass=LegacySourceFileContent.class)
    private LegacySourceFileContent legacyFileContent;
    @ElementBy(cssSelector="[data-testid='raw-file-btn']")
    private PageElement rawLink;
    @ElementBy(cssSelector="[data-testid='file-content-mode-source']")
    private PageElement sourceModeButton;

    public FileSourcePage(String projectKey, String repoSlug, String path) {
        super(projectKey, repoSlug, path);
    }

    public FileSourcePage(String projectKey, String repoSlug, String path, String commitId) {
        super(projectKey, repoSlug, path, new FileLayoutPage.RevisionSpecifier(commitId, null));
    }

    public FileSourcePage(String projectKey, String repoSlug, String path, FileLayoutPage.RevisionSpecifier revisionSpecifier) {
        super(projectKey, repoSlug, path, revisionSpecifier);
    }

    public void closeDiffOptions() {
        this.diffOptionsDropdownTrigger.click();
        PageElement diffOptionsDropdownContent = this.getDiffOptionsDropdownContent();
        Poller.waitUntilFalse((TimedQuery)diffOptionsDropdownContent.timed().isVisible());
    }

    private <T extends BlameRow> List<BlameRow> getBlame(By locator, Class<T> clazz) {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(locator).timed().isPresent());
        return Lists.transform((List)this.elementFinder.findAll(locator), element -> (BlameRow)this.pageBinder.bind(clazz, new Object[]{element}));
    }

    public PageElement getDiffOptionsCSE(String text) {
        return this.elementFinder.find(By.className((String)"diff-options-dropdown-content")).find(By.xpath((String)("//*[.=('" + text + "')]")));
    }

    private PageElement getDiffOptionsDropdownContent() {
        return this.elementFinder.find(By.className((String)"diff-options-dropdown-content"));
    }

    public EditFileActions getEditActions() {
        return (EditFileActions)this.pageBinder.bind(EditFileActions.class, new Object[]{this.elementFinder.find(By.className((String)"editing-actions"))});
    }

    public PageElement getEditButton() {
        this.getFileContent().waitUntilFileContentLoaded();
        return this.elementFinder.find(By.className((String)"in-browser-edit-button"));
    }

    public CodeMirrorSourceFileContent getEditFileContent() {
        return this.codemirrorFileContent;
    }

    public EditFileFooter getEditFooter() {
        return (EditFileFooter)this.pageBinder.bind(EditFileFooter.class, new Object[]{this.elementFinder.find(By.className((String)"edit-footer"))});
    }

    public PageElement getEditHeader() {
        return this.elementFinder.find(By.className((String)"edit-header"));
    }

    @Override
    public SourceFileContent getFileContent() {
        return this.legacyFileContent;
    }

    public PageElement getPrimaryCSE(String text) {
        return this.elementFinder.find(By.cssSelector((String)"[data-testid='primary-actions']")).find(By.xpath((String)("//*[.=('" + text + "')]")));
    }

    public String getRawLink() {
        this.getFileContent().waitUntilFileContentLoaded();
        return this.rawLink.getAttribute("href");
    }

    public PageElement getSecondaryCSE(String text) {
        return this.elementFinder.find(By.cssSelector((String)"[data-testid='secondary-actions']")).find(By.xpath((String)("//*[.=('" + text + "')]")));
    }

    public PageElement getShowSourceButton() {
        return this.elementFinder.find(By.cssSelector((String)"[data-testid='use-default-handlers-button']"));
    }

    public List<String> getSourceLines() {
        String wholeContent = this.fileContentTable.find(By.cssSelector((String)".user-interactive-area .whole-file-contents")).getText();
        return List.of(wholeContent.split("\n"));
    }

    public String getWarningMessage() {
        return this.elementFinder.find(By.className((String)"file-messages-wrapper")).getText();
    }

    public String getWarningMessageFileNotExists() {
        return this.elementFinder.find(By.className((String)"error-section-message")).getText();
    }

    public TimedCondition hasMultipleEditHeaders() {
        return Conditions.forSupplier(() -> this.elementFinder.findAll(By.className((String)"edit-header")).size() > 1);
    }

    public TimedCondition isInEditMode() {
        return this.elementFinder.find(By.className((String)"source-editor")).withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isPresent();
    }

    public TimedCondition isModalVisible(String text) {
        return this.elementFinder.find(By.xpath((String)("//*[.=('" + text + "')]"))).timed().isVisible();
    }

    public TimedCondition isShowingBlame() {
        return this.elementFinder.find(By.cssSelector((String)".blame-gutter")).withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible();
    }

    public void openDiffOptions() {
        this.diffOptionsDropdownTrigger.click();
        PageElement diffOptionsDropdownContent = this.getDiffOptionsDropdownContent();
        Poller.waitUntilTrue((TimedQuery)diffOptionsDropdownContent.timed().isVisible());
    }

    public FileSourcePage loadUntilRevision(String revisionId) {
        return this.loadRevision(revisionId, FileSourcePage.class);
    }

    public List<BlameRow> showBlame() {
        this.getFileContent().waitUntilFileContentLoaded();
        this.blameButton.click();
        return this.getBlame(By.cssSelector((String)".blame-gutter-content"), ReactBlameRow.class);
    }

    public TimedCondition showBranchActions() {
        return this.elementFinder.find(By.cssSelector((String)".blame[data-span]")).withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible();
    }

    public void showDiff() {
        this.getFileContent().waitUntilFileContentLoaded();
        this.diffModeButton.click();
        this.getFileContent().waitUntilFileContentLoaded();
    }

    public void showSource() {
        this.getFileContent().waitUntilFileContentLoaded();
        this.sourceModeButton.click();
        this.getFileContent().waitUntilFileContentLoaded();
    }

    public void typeInEditor(String text) {
        this.elementFinder.find(By.cssSelector((String)".file-viewer .CodeMirror")).javascript().execute("arguments[0].CodeMirror.setValue('" + text.replace("\n", "\\n").replace("\t", "\\t").replace("'", "\\'") + "');", new Object[0]);
    }

    @Override
    protected String getPathComponent() {
        return "browse";
    }

    public static class ReactBlameRow
    implements BlameRow {
        private final PageElement firstLine;
        @Inject
        private PageElementFinder elementFinder;

        public ReactBlameRow(PageElement firstLine) {
            this.firstLine = firstLine;
        }

        @Override
        public String getAuthor() {
            return this.firstLine.find(By.cssSelector((String)".user-name")).getText();
        }

        @Override
        public String getCommit() {
            return ElementUtils.scrollIntoViewIfNeeded(this.firstLine).find(By.cssSelector((String)".commit-hash")).getText();
        }

        @Override
        public String getDate() {
            return ElementUtils.scrollIntoViewIfNeeded(this.firstLine).find(By.className((String)"blame-commit-date")).getText();
        }

        @Override
        public int getSpan(String commitId) {
            return Integer.parseInt(this.elementFinder.find(By.cssSelector((String)(".blame-gutter[data-commit='" + commitId + "']"))).getAttribute("data-span"));
        }
    }

    public static interface BlameRow {
        public String getAuthor();

        public String getCommit();

        public String getDate();

        public int getSpan(String var1);
    }
}

