/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mesh;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import com.atlassian.webdriver.bitbucket.page.admin.mesh.MeshNodeDialog;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class MeshAdminPage
extends BitbucketAdminPage {
    public MeshAdminPage() {
    }

    public MeshAdminPage(String webSudoPassword) {
        super(webSudoPassword);
    }

    public String getUrl() {
        return "/admin/git/mesh";
    }

    public MeshNodeDialog editNode(int index) {
        this.clickNodeActions(index);
        this.clickEditAction();
        return (MeshNodeDialog)this.pageBinder.bind(MeshNodeDialog.class, new Object[]{this.elementFinder.find(By.cssSelector((String)"[data-testid='node-modal']"))});
    }

    private void clickEditAction() {
        PageElement actionMenu = this.elementFinder.find(By.cssSelector((String)"[data-testid='actions-menu--content']"));
        Poller.waitUntilTrue((TimedQuery)actionMenu.timed().isVisible());
        PageElement editNodeItem = actionMenu.find(By.cssSelector((String)"[data-testid='edit-node']"));
        Poller.waitUntilTrue((TimedQuery)editNodeItem.timed().isVisible());
        editNodeItem.click();
    }

    private void clickNodeActions(int index) {
        TimedQuery<List<PageElement>> nodeActionButtons = this.getNodeActionButtons();
        Poller.waitUntil(nodeActionButtons, (Matcher)Matchers.iterableWithSize((int)3));
        ((PageElement)((List)nodeActionButtons.now()).get(index)).click();
    }

    private TimedQuery<List<PageElement>> getNodeActionButtons() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)this.elementFinder.findAll(By.cssSelector((String)"[data-testid='actions-menu--trigger']")).stream().collect(MoreCollectors.toImmutableList()));
    }
}

