/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.bitbucket.pageobjects.element.ConfirmDialog;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AvatarPickerDialog;
import com.atlassian.webdriver.bitbucket.element.ClearCaptchaDialog;
import com.atlassian.webdriver.bitbucket.element.DeleteConfirmationDialog;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.element.UserAvatarDeleteDialog;
import com.atlassian.webdriver.bitbucket.element.UserAvatarPickerDialog;
import com.atlassian.webdriver.bitbucket.element.UserGroupsTable;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.accesstokens.AdminAccessTokensPage;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import com.atlassian.webdriver.bitbucket.page.admin.GlobalPermissionsPage;
import com.atlassian.webdriver.bitbucket.page.admin.users.UserTablePage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.base.Supplier;
import org.openqa.selenium.By;

public class UserEditPage
extends BitbucketAdminPage {
    @ElementBy(id="change-password-dialog")
    PageElement changePasswordDialog;
    private final String username;
    @ElementBy(className="user-avatar")
    private PageElement avatar;
    @ElementBy(id="name")
    private PageElement nameLabel;
    @ElementBy(id="fullname")
    private PageElement fullnameTextbox;
    @ElementBy(id="email")
    private PageElement emailTextbox;
    @ElementBy(id="password")
    private PageElement passwordTextbox;
    @ElementBy(id="passwordConfirm")
    private PageElement passwordConfirmTextbox;
    @ElementBy(className="user-details-form")
    private PageElement userDetailsForm;
    @ElementBy(cssSelector=".details .buttons .save")
    private PageElement saveDetails;
    @ElementBy(cssSelector=".details .buttons .cancel")
    private PageElement cancelDetails;
    @ElementBy(cssSelector="#users-breadcrumb")
    private PageElement usersLink;
    @ElementBy(cssSelector="#update-password-user")
    private PageElement changePassword;
    @ElementBy(cssSelector="#clear-captcha")
    private PageElement clearCaptcha;
    @ElementBy(cssSelector="#change-password-dialog .cancel-button")
    private PageElement cancelChangePassword;
    @ElementBy(cssSelector="#change-password-dialog .confirm-button")
    private PageElement savePassword;
    @ElementBy(cssSelector="#change-password-dialog div.error")
    private PageElement changePasswordError;
    @ElementBy(className="avatar-delete-trigger")
    private PageElement deleteAvatar;
    @ElementBy(className="avatar-picker-trigger")
    private PageElement editAvatar;
    @ElementBy(id="edit-details")
    private PageElement editUser;
    @ElementBy(id="delete-user")
    private PageElement deleteUser;
    @ElementBy(id="change-permissions")
    private PageElement changePermissions;
    @ElementBy(cssSelector="[data-testid='confirm-action-modal']")
    private PageElement modal;
    @ElementBy(id="personal-tokens-tab")
    private PageElement personalTokens;

    public UserEditPage() {
        this.username = null;
    }

    public UserEditPage(String username) {
        this.username = username;
    }

    public String getUrl() {
        String url = "/admin/users/view";
        return this.username == null ? url : url + "?name=" + this.username;
    }

    public String getAvatarUrl() {
        return this.avatar.find(By.tagName((String)"img")).getAttribute("src");
    }

    public String getName() {
        return this.nameLabel.getValue();
    }

    public String getFullname() {
        return this.fullnameTextbox.getValue();
    }

    public String getEmail() {
        return this.emailTextbox.getValue();
    }

    public AvatarPickerDialog<UserEditPage> clickEditAvatar() {
        this.editAvatar.click();
        return (AvatarPickerDialog)((Object)this.pageBinder.bind(UserAvatarPickerDialog.class, new Object[]{this}));
    }

    public UserEditPage clickEditDetails() {
        this.editUser.click();
        return this;
    }

    public UserEditPage clickClearCaptcha() {
        this.clearCaptcha.click();
        Poller.waitUntilTrue((TimedQuery)this.clearCaptcha.timed().isVisible());
        return this;
    }

    public UserEditPage confirmClearCaptcha() {
        ClearCaptchaDialog clearCaptchaDialog = (ClearCaptchaDialog)((Object)this.pageBinder.bind(ClearCaptchaDialog.class, new Object[0]));
        clearCaptchaDialog.clickConfirm();
        Poller.waitUntilFalse((TimedQuery)this.clearCaptcha.timed().isVisible());
        return this;
    }

    public boolean canUpdateUserAvatar() {
        return this.editAvatar.isPresent();
    }

    public boolean canUpdateUserDetails() {
        return this.editUser.isPresent();
    }

    public boolean canUpdateUserPassword() {
        return this.changePassword.isPresent();
    }

    public boolean canClearCaptcha() {
        return this.clearCaptcha.isPresent();
    }

    public UserEditPage clickSaveUserDetails() {
        this.saveDetails.click();
        Poller.waitUntilTrue((TimedQuery)Conditions.or((TimedQuery[])new TimedQuery[]{Conditions.not((TimedQuery)this.userDetailsForm.timed().hasClass("editing")), this.userDetailsForm.find(By.className((String)"error")).timed().isPresent(), this.elementFinder.find(By.className((String)"aui-message-error")).timed().isVisible()}));
        return this;
    }

    public UserEditPage setFullname(String fullname) {
        return this.updateField(this.fullnameTextbox, fullname);
    }

    public UserEditPage setEmail(String email) {
        return this.updateField(this.emailTextbox, email);
    }

    public UserTablePage clickUsersLink() {
        return this.clickAndBind(this.usersLink, UserTablePage.class);
    }

    public ChangePasswordDialog clickChangePassword() {
        this.changePassword.click();
        Dialog2 dialog = (Dialog2)((Object)this.pageBinder.bind(Dialog2.class, new Object[]{By.id((String)"change-password-dialog")}));
        Poller.waitUntilTrue((TimedQuery)dialog.isOpen());
        return new ChangePasswordDialog();
    }

    public boolean hasGravatarNotice() {
        return this.elementFinder.find(By.className((String)"gravatar-notice")).isVisible();
    }

    public ConfirmDialog getDeleteUserDialog() {
        return (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.modal});
    }

    public AdminAccessTokensPage clickAccessTokensPage() {
        this.personalTokens.click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.id((String)"access-tokens-user-account-admin")).timed().isVisible());
        return (AdminAccessTokensPage)this.pageBinder.bind(AdminAccessTokensPage.class, new Object[]{this.username});
    }

    public boolean canDeleteUserAvatar() {
        this.deleteAvatar.javascript().execute("arguments[0].parentNode.style.opacity=1", new Object[0]);
        return this.deleteAvatar.isVisible();
    }

    public DeleteConfirmationDialog<UserEditPage> clickDeleteAvatar() {
        this.deleteAvatar.click();
        return (DeleteConfirmationDialog)((Object)this.pageBinder.bind(UserAvatarDeleteDialog.class, new Object[]{this}));
    }

    public GlobalPermissionsPage clickChangePermissions() {
        return this.clickAndBind(this.changePermissions, GlobalPermissionsPage.class);
    }

    public boolean hasUpdateConfirmation(String ... containingText) {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"aui-flag")).timed().isVisible());
        PageElement successMessage = this.elementFinder.find(By.className((String)"aui-message-success"));
        for (String text : containingText) {
            if (successMessage.getText().contains(text)) continue;
            return false;
        }
        return successMessage.isPresent() && successMessage.isVisible();
    }

    public Iterable<String> getFieldsWithErrors() {
        return ElementUtils.getFieldsWithErrors(this.elementFinder.find(By.className((String)"user-details-form")));
    }

    public UserGroupsTable getGroups() {
        return (UserGroupsTable)this.pageBinder.bind(UserGroupsTable.class, new Object[]{this.elementFinder.find(By.id((String)"user-groups-table"))});
    }

    public boolean hasSshKeysTab() {
        return this.elementFinder.find(By.id((String)"ssh-tab")).isPresent();
    }

    public UserEditPage waitAvatarIsUpdated() {
        Poller.waitUntilFalse((TimedQuery)this.avatar.find(By.className((String)"spinner")).timed().isPresent());
        return (UserEditPage)this.pageBinder.bind(UserEditPage.class, new Object[0]);
    }

    private UserEditPage updateField(PageElement element, String text) {
        element.clear().type(new CharSequence[]{text});
        return (UserEditPage)this.pageBinder.bind(UserEditPage.class, new Object[0]);
    }

    private <P extends BitbucketPage> P clickAndBind(PageElement element, Class<P> page) {
        element.click();
        return (P)((BitbucketPage)this.pageBinder.bind(page, new Object[0]));
    }

    public class ChangePasswordDialog {
        protected static final String ID = "change-password-dialog";

        public ChangePasswordDialog setPassword(String password) {
            UserEditPage.this.updateField(UserEditPage.this.passwordTextbox, password);
            return this;
        }

        public ChangePasswordDialog setPasswordConfirm(String password) {
            UserEditPage.this.updateField(UserEditPage.this.passwordConfirmTextbox, password);
            return this;
        }

        public UserEditPage clickCancel() {
            UserEditPage.this.cancelChangePassword.click();
            return UserEditPage.this;
        }

        public UserEditPage clickSavePassword() {
            Dialog2 dialog = (Dialog2)((Object)UserEditPage.this.pageBinder.bind(Dialog2.class, new Object[]{By.id((String)ID)}));
            UserEditPage.this.savePassword.click();
            Poller.waitUntilFalse((TimedQuery)dialog.isOpen());
            return UserEditPage.this;
        }

        public ChangePasswordDialog clickSaveWithError() {
            UserEditPage.this.savePassword.click();
            Poller.waitUntilTrue((TimedQuery)UserEditPage.this.elementFinder.find(By.cssSelector((String)"div.error")).timed().isVisible());
            return this;
        }

        public boolean hasError(String containingText) {
            Poller.waitUntilFalse((TimedQuery)Queries.forSupplier((Timeouts)UserEditPage.this.timeouts, (Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return UserEditPage.this.changePasswordDialog.findAll(By.cssSelector((String)"div.error")).isEmpty();
                }
            }));
            for (PageElement error : UserEditPage.this.changePasswordDialog.findAll(By.cssSelector((String)"div.error"))) {
                if (!error.getText().contains(containingText)) continue;
                return true;
            }
            return false;
        }
    }
}

