/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.matchers;

import com.atlassian.webdriver.bitbucket.element.RecentReposDropdown;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class RecentRepositoriesMatchers {
    private RecentRepositoriesMatchers() {
        throw new UnsupportedOperationException("Do not instantiate " + this.getClass().getSimpleName());
    }

    @Nonnull
    public static Matcher<RecentReposDropdown.RecentRepo> recentRepository(@Nullable String expectedProjectKey, @Nullable String expectedRepositorySlug) {
        return Matchers.allOf(RecentRepositoriesMatchers.withProjectKey(expectedProjectKey), RecentRepositoriesMatchers.withRepositorySlug(expectedRepositorySlug));
    }

    @Nonnull
    public static Matcher<RecentReposDropdown.RecentRepo> withProjectKey(@Nullable String expectedProjectKey) {
        return new FeatureMatcher<RecentReposDropdown.RecentRepo, String>(Matchers.is((Object)expectedProjectKey), "project key", "projectKey"){

            protected String featureValueOf(RecentReposDropdown.RecentRepo actual) {
                return actual.getProjectKey();
            }
        };
    }

    @Nonnull
    public static Matcher<RecentReposDropdown.RecentRepo> withRepositorySlug(@Nullable String expectedRepositorySlug) {
        return new FeatureMatcher<RecentReposDropdown.RecentRepo, String>(Matchers.is((Object)expectedRepositorySlug), "repository slug", "repositorySlug"){

            protected String featureValueOf(RecentReposDropdown.RecentRepo actual) {
                return actual.getRepoSlug();
            }
        };
    }
}

