/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket;

import com.google.common.primitives.Ints;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.html5.SessionStorage;

class JavascriptSessionStorage
implements SessionStorage {
    private final JavascriptExecutor js;

    public JavascriptSessionStorage(JavascriptExecutor js) {
        this.js = js;
    }

    public void clear() {
        this.js.executeScript("return window.sessionStorage.clear();", new Object[0]);
    }

    public String getItem(String key) {
        return (String)this.js.executeScript("return window.sessionStorage.getItem(arguments[0]);", new Object[]{key});
    }

    public Set<String> keySet() {
        return new LinkedHashSet<String>((List)this.js.executeScript("return Object.keys(sessionStorage);", new Object[0]));
    }

    public String removeItem(String key) {
        return (String)this.js.executeScript("return window.sessionStorage.removeItem(arguments[0]);", new Object[]{key});
    }

    public void setItem(String key, String value) {
        this.js.executeScript("return window.sessionStorage.setItem(arguments[0], arguments[1]);", new Object[]{key, value});
    }

    public int size() {
        return Ints.saturatedCast((long)((Long)this.js.executeScript("return window.sessionStorage.length;", new Object[0])));
    }
}

